/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

import org.apache.solr.util.hll.BigEndianAscendingWordDeserializer;
import org.apache.solr.util.hll.BigEndianAscendingWordSerializer;
import org.apache.solr.util.hll.HLLMetadata;
import org.apache.solr.util.hll.HLLType;
import org.apache.solr.util.hll.IHLLMetadata;
import org.apache.solr.util.hll.ISchemaVersion;
import org.apache.solr.util.hll.IWordDeserializer;
import org.apache.solr.util.hll.IWordSerializer;
import org.apache.solr.util.hll.SerializationUtil;

class SchemaVersionOne
implements ISchemaVersion {
    public static final int SCHEMA_VERSION = 1;
    private static final HLLType[] TYPE_ORDINALS = new HLLType[]{HLLType.EMPTY, HLLType.EXPLICIT, HLLType.SPARSE, HLLType.FULL};
    private static final int HEADER_BYTE_COUNT = 3;
    private static final int EXPLICIT_OFF = 0;
    private static final int EXPLICIT_AUTO = 63;

    SchemaVersionOne() {
    }

    @Override
    public int paddingBytes(HLLType type) {
        return 3;
    }

    @Override
    public void writeMetadata(byte[] bytes, IHLLMetadata metadata) {
        HLLType type = metadata.HLLType();
        int typeOrdinal = SchemaVersionOne.getOrdinal(type);
        int explicitCutoffValue = metadata.explicitOff() ? 0 : (metadata.explicitAuto() ? 63 : metadata.log2ExplicitCutoff() + 1);
        bytes[0] = SerializationUtil.packVersionByte(1, typeOrdinal);
        bytes[1] = SerializationUtil.packParametersByte(metadata.registerWidth(), metadata.registerCountLog2());
        bytes[2] = SerializationUtil.packCutoffByte(explicitCutoffValue, metadata.sparseEnabled());
    }

    @Override
    public IHLLMetadata readMetadata(byte[] bytes) {
        byte versionByte = bytes[0];
        byte parametersByte = bytes[1];
        byte cutoffByte = bytes[2];
        int typeOrdinal = SerializationUtil.typeOrdinal(versionByte);
        int explicitCutoffValue = SerializationUtil.explicitCutoff(cutoffByte);
        boolean explicitOff = explicitCutoffValue == 0;
        boolean explicitAuto = explicitCutoffValue == 63;
        int log2ExplicitCutoff = explicitOff || explicitAuto ? -1 : explicitCutoffValue - 1;
        return new HLLMetadata(1, SchemaVersionOne.getType(typeOrdinal), SerializationUtil.registerCountLog2(parametersByte), SerializationUtil.registerWidth(parametersByte), log2ExplicitCutoff, explicitOff, explicitAuto, SerializationUtil.sparseEnabled(cutoffByte));
    }

    @Override
    public IWordSerializer getSerializer(HLLType type, int wordLength, int wordCount) {
        return new BigEndianAscendingWordSerializer(wordLength, wordCount, this.paddingBytes(type));
    }

    @Override
    public IWordDeserializer getDeserializer(HLLType type, int wordLength, byte[] bytes) {
        return new BigEndianAscendingWordDeserializer(wordLength, this.paddingBytes(type), bytes);
    }

    @Override
    public int schemaVersionNumber() {
        return 1;
    }

    private static int getOrdinal(HLLType type) {
        for (int i = 0; i < TYPE_ORDINALS.length; ++i) {
            if (!TYPE_ORDINALS[i].equals((Object)type)) continue;
            return i;
        }
        throw new RuntimeException("Unknown HLL type " + String.valueOf((Object)type));
    }

    private static HLLType getType(int ordinal) {
        if (ordinal < 0 || ordinal >= TYPE_ORDINALS.length) {
            throw new IllegalArgumentException("Invalid type ordinal '" + ordinal + "'. Only 0-" + (TYPE_ORDINALS.length - 1) + " inclusive allowed.");
        }
        return TYPE_ORDINALS[ordinal];
    }
}

