/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.extraction.ExtractingParams;
import org.apache.solr.handler.extraction.ExtractionMetadata;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SolrContentHandler
extends DefaultHandler
implements ExtractingParams {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String contentFieldName = "content";
    protected final SolrInputDocument document;
    protected final ExtractionMetadata metadata;
    protected final SolrParams params;
    protected final StringBuilder catchAllBuilder = new StringBuilder(2048);
    protected final IndexSchema schema;
    protected final Map<String, StringBuilder> fieldBuilders;
    private final Deque<StringBuilder> bldrStack = new ArrayDeque<StringBuilder>();
    protected final boolean captureAttribs;
    protected final boolean lowerNames;
    protected final String unknownFieldPrefix;
    protected final String defaultField;
    private final boolean literalsOverride;
    private Set<String> literalFieldNames = null;

    public SolrContentHandler(ExtractionMetadata metadata, SolrParams params, IndexSchema schema) {
        this.document = new SolrInputDocument();
        this.metadata = metadata;
        this.params = params;
        this.schema = schema;
        this.lowerNames = params.getBool("lowernames", false);
        this.captureAttribs = params.getBool("captureAttr", false);
        this.literalsOverride = params.getBool("literalsOverride", true);
        this.unknownFieldPrefix = params.get("uprefix", "");
        this.defaultField = params.get("defaultField", "");
        String[] captureFields = params.getParams("capture");
        if (captureFields != null && captureFields.length > 0) {
            this.fieldBuilders = new HashMap<String, StringBuilder>();
            for (int i = 0; i < captureFields.length; ++i) {
                this.fieldBuilders.put(captureFields[i], new StringBuilder());
            }
        } else {
            this.fieldBuilders = Collections.emptyMap();
        }
        this.bldrStack.add(this.catchAllBuilder);
    }

    public SolrInputDocument newDocument() {
        this.addLiterals();
        this.addMetadata();
        this.addContent();
        this.addCapturedContent();
        if (log.isDebugEnabled()) {
            log.debug("Doc: {}", (Object)this.document);
        }
        return this.document;
    }

    protected void addCapturedContent() {
        for (Map.Entry<String, StringBuilder> entry : this.fieldBuilders.entrySet()) {
            if (entry.getValue().length() <= 0) continue;
            String fieldName = entry.getKey();
            if (this.literalsOverride && this.literalFieldNames.contains(fieldName)) continue;
            this.addField(fieldName, entry.getValue().toString(), null);
        }
    }

    protected void addContent() {
        if (this.literalsOverride && this.literalFieldNames.contains(contentFieldName)) {
            return;
        }
        this.addField(contentFieldName, this.catchAllBuilder.toString(), null);
    }

    public void appendToContent(String text) {
        if (text != null && !text.isEmpty()) {
            this.catchAllBuilder.append(text);
        }
    }

    protected void addLiterals() {
        Iterator paramNames = this.params.getParameterNamesIterator();
        this.literalFieldNames = new HashSet<String>();
        while (paramNames.hasNext()) {
            String pname = (String)paramNames.next();
            if (!pname.startsWith("literal.")) continue;
            String name = pname.substring("literal.".length());
            this.addField(name, null, this.params.getParams(pname));
            this.literalFieldNames.add(name);
        }
    }

    protected void addMetadata() {
        for (String name : this.metadata.keySet()) {
            if (this.literalsOverride && this.literalFieldNames.contains(name)) continue;
            List<String> vals = this.metadata.get(name);
            this.addField(name, null, vals.toArray(new String[0]));
        }
    }

    protected void addField(String fname, String fval, String[] vals) {
        Object name;
        SchemaField sf;
        if (this.lowerNames) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fname.length(); ++i) {
                char ch = fname.charAt(i);
                ch = !Character.isLetterOrDigit(ch) ? (char)'_' : (char)Character.toLowerCase(ch);
                sb.append(ch);
            }
            fname = sb.toString();
        }
        if ((sf = this.schema.getFieldOrNull((String)(name = this.findMappedName(fname)))) == null && this.unknownFieldPrefix.length() > 0) {
            name = this.unknownFieldPrefix + (String)name;
            sf = this.schema.getFieldOrNull((String)name);
        } else if (sf == null && this.defaultField.length() > 0 && !((String)name).equals("resourceName")) {
            name = this.defaultField;
            sf = this.schema.getFieldOrNull((String)name);
        }
        if (sf == null && this.unknownFieldPrefix.length() == 0 && Objects.equals(name, "resourceName")) {
            return;
        }
        if (vals != null && vals.length == 1) {
            fval = vals[0];
            vals = null;
        }
        if (sf != null && !sf.multiValued() && vals != null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String val : vals) {
                if (first) {
                    first = false;
                } else {
                    builder.append(' ');
                }
                builder.append(val);
            }
            fval = builder.toString();
            vals = null;
        }
        if (fval != null) {
            this.document.addField((String)name, (Object)fval);
        }
        if (vals != null) {
            for (String val : vals) {
                this.document.addField((String)name, (Object)val);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        StringBuilder theBldr = this.fieldBuilders.get(localName);
        if (theBldr != null) {
            this.bldrStack.add(theBldr);
        }
        if (this.captureAttribs) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.addField(localName, attributes.getValue(i), null);
            }
        } else {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.bldrStack.getLast().append(' ').append(attributes.getValue(i));
            }
        }
        this.bldrStack.getLast().append(' ');
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        StringBuilder theBldr = this.fieldBuilders.get(localName);
        if (theBldr != null) {
            this.bldrStack.removeLast();
            assert (this.bldrStack.size() >= 1);
        }
        this.bldrStack.getLast().append(' ');
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.bldrStack.getLast().append(chars, offset, length);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int offset, int length) throws SAXException {
        this.characters(chars, offset, length);
    }

    protected String findMappedName(String name) {
        return this.params.get("fmap." + name, name);
    }
}

