/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.Locale;
import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;

public class OrdinalFunction {
    public static final String name = "ordinal";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires 2 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream percValue = params[0];
        int ord = 0;
        if (params[0] instanceof IntValue && params[0] instanceof ConstantValue) {
            ord = ((IntValue)percValue).getInt();
            if (ord == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires the ordinal to be >= 1 or <= -1, 0 is not accepted.");
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires a constant int value (the ordinal) as the first argument.");
        }
        AnalyticsValueStream param = params[1];
        if (param instanceof DateValueStream) {
            return new DateOrdinalFunction((DateValueStream)param, ord);
        }
        if (param instanceof IntValueStream) {
            return new IntOrdinalFunction((IntValueStream)param, ord);
        }
        if (param instanceof LongValueStream) {
            return new LongOrdinalFunction((LongValueStream)param, ord);
        }
        if (param instanceof FloatValueStream) {
            return new FloatOrdinalFunction((FloatValueStream)param, ord);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleOrdinalFunction((DoubleValueStream)param, ord);
        }
        if (param instanceof StringValueStream) {
            return new StringOrdinalFunction((StringValueStream)param, ord);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires a comparable parameter.");
    };

    protected static String createOrdinalExpressionString(AnalyticsValueStream param, double ord) {
        return String.format(Locale.ROOT, "%s(%s,%s)", name, ord, param.getExpressionStr());
    }

    static class StringOrdinalFunction
    extends StringValue.AbstractStringValue
    implements ReductionFunction {
        private SortedListCollector.SortedStringListCollector collector;
        private int ordinal;
        public static final String name = "ordinal";
        private final String exprStr;

        public StringOrdinalFunction(StringValueStream param, int ordinal) {
            this.collector = new SortedListCollector.SortedStringListCollector(param);
            this.ordinal = ordinal;
            this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
        }

        @Override
        public String getString() {
            int size = this.collector.size();
            if (this.ordinal > 0) {
                return this.ordinal <= size ? (String)this.collector.get(this.ordinal - 1) : null;
            }
            return this.ordinal * -1 <= size ? (String)this.collector.get(size + this.ordinal) : null;
        }

        @Override
        public boolean exists() {
            return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedStringListCollector)sync.apply(this.collector);
            this.collector.calcOrdinal(this.ordinal);
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DateOrdinalFunction
    extends DateValue.AbstractDateValue
    implements ReductionFunction {
        private SortedListCollector.SortedLongListCollector collector;
        private int ordinal;
        public static final String name = "ordinal";
        private final String exprStr;

        public DateOrdinalFunction(LongValueStream param, int ordinal) {
            this.collector = new SortedListCollector.SortedLongListCollector(param);
            this.ordinal = ordinal;
            this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
        }

        @Override
        public long getLong() {
            int size = this.collector.size();
            if (this.ordinal > 0) {
                return this.ordinal <= size ? (Long)this.collector.get(this.ordinal - 1) : 0L;
            }
            return this.ordinal * -1 <= size ? (Long)this.collector.get(size + this.ordinal) : 0L;
        }

        @Override
        public boolean exists() {
            return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
            this.collector.calcOrdinal(this.ordinal);
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DoubleOrdinalFunction
    extends DoubleValue.AbstractDoubleValue
    implements ReductionFunction {
        private SortedListCollector.SortedDoubleListCollector collector;
        private int ordinal;
        public static final String name = "ordinal";
        private final String exprStr;

        public DoubleOrdinalFunction(DoubleValueStream param, int ordinal) {
            this.collector = new SortedListCollector.SortedDoubleListCollector(param);
            this.ordinal = ordinal;
            this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
        }

        @Override
        public double getDouble() {
            int size = this.collector.size();
            if (this.ordinal > 0) {
                return this.ordinal <= size ? (Double)this.collector.get(this.ordinal - 1) : 0.0;
            }
            return this.ordinal * -1 <= size ? (Double)this.collector.get(size + this.ordinal) : 0.0;
        }

        @Override
        public boolean exists() {
            return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedDoubleListCollector)sync.apply(this.collector);
            this.collector.calcOrdinal(this.ordinal);
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class FloatOrdinalFunction
    extends FloatValue.AbstractFloatValue
    implements ReductionFunction {
        private SortedListCollector.SortedFloatListCollector collector;
        private int ordinal;
        public static final String name = "ordinal";
        private final String exprStr;

        public FloatOrdinalFunction(FloatValueStream param, int ordinal) {
            this.collector = new SortedListCollector.SortedFloatListCollector(param);
            this.ordinal = ordinal;
            this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
        }

        @Override
        public float getFloat() {
            int size = this.collector.size();
            if (this.ordinal > 0) {
                return this.ordinal <= size ? ((Float)this.collector.get(this.ordinal - 1)).floatValue() : 0.0f;
            }
            return this.ordinal * -1 <= size ? ((Float)this.collector.get(size + this.ordinal)).floatValue() : 0.0f;
        }

        @Override
        public boolean exists() {
            return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedFloatListCollector)sync.apply(this.collector);
            this.collector.calcOrdinal(this.ordinal);
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class LongOrdinalFunction
    extends LongValue.AbstractLongValue
    implements ReductionFunction {
        private SortedListCollector.SortedLongListCollector collector;
        private int ordinal;
        public static final String name = "ordinal";
        private final String exprStr;

        public LongOrdinalFunction(LongValueStream param, int ordinal) {
            this.collector = new SortedListCollector.SortedLongListCollector(param);
            this.ordinal = ordinal;
            this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
        }

        @Override
        public long getLong() {
            int size = this.collector.size();
            if (this.ordinal > 0) {
                return this.ordinal <= size ? (Long)this.collector.get(this.ordinal - 1) : 0L;
            }
            return this.ordinal * -1 <= size ? (Long)this.collector.get(size + this.ordinal) : 0L;
        }

        @Override
        public boolean exists() {
            return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
            this.collector.calcOrdinal(this.ordinal);
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class IntOrdinalFunction
    extends IntValue.AbstractIntValue
    implements ReductionFunction {
        private SortedListCollector.SortedIntListCollector collector;
        private int ordinal;
        public static final String name = "ordinal";
        private final String exprStr;

        public IntOrdinalFunction(IntValueStream param, int ordinal) {
            this.collector = new SortedListCollector.SortedIntListCollector(param);
            this.ordinal = ordinal;
            this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
        }

        @Override
        public int getInt() {
            int size = this.collector.size();
            if (this.ordinal > 0) {
                return this.ordinal <= size ? (Integer)this.collector.get(this.ordinal - 1) : 0;
            }
            return this.ordinal * -1 <= size ? (Integer)this.collector.get(size + this.ordinal) : 0;
        }

        @Override
        public boolean exists() {
            return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedIntListCollector)sync.apply(this.collector);
            this.collector.calcOrdinal(this.ordinal);
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }
}

