/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.internal.Signal;

public class StandardComponentId
extends ComponentId.Lazy {
    private final ExporterType standardType;

    StandardComponentId(ExporterType standardType) {
        super(standardType.value);
        this.standardType = standardType;
    }

    public ExporterType getStandardType() {
        return this.standardType;
    }

    public static enum ExporterType {
        OTLP_GRPC_SPAN_EXPORTER("otlp_grpc_span_exporter", Signal.SPAN),
        OTLP_HTTP_SPAN_EXPORTER("otlp_http_span_exporter", Signal.SPAN),
        OTLP_HTTP_JSON_SPAN_EXPORTER("otlp_http_json_span_exporter", Signal.SPAN),
        OTLP_GRPC_LOG_EXPORTER("otlp_grpc_log_exporter", Signal.LOG),
        OTLP_HTTP_LOG_EXPORTER("otlp_http_log_exporter", Signal.LOG),
        OTLP_HTTP_JSON_LOG_EXPORTER("otlp_http_json_log_exporter", Signal.LOG),
        OTLP_GRPC_METRIC_EXPORTER("otlp_grpc_metric_exporter", Signal.METRIC),
        OTLP_HTTP_METRIC_EXPORTER("otlp_http_metric_exporter", Signal.METRIC),
        OTLP_HTTP_JSON_METRIC_EXPORTER("otlp_http_json_metric_exporter", Signal.METRIC),
        ZIPKIN_HTTP_SPAN_EXPORTER("zipkin_http_span_exporter", Signal.SPAN),
        ZIPKIN_HTTP_JSON_SPAN_EXPORTER("zipkin_http_span_exporter", Signal.SPAN),
        OTLP_GRPC_PROFILES_EXPORTER("TBD", Signal.PROFILE);

        final String value;
        private final Signal signal;

        private ExporterType(String value, Signal signal) {
            this.value = value;
            this.signal = signal;
        }

        public Signal signal() {
            return this.signal;
        }
    }
}

