/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.encrypt.DesEncrypter;
import org.freeplane.features.encrypt.EncryptionHeader;
import org.freeplane.features.map.IEncrypter;

public class Aes256Encrypter
implements IEncrypter {
    private static final int SALT_LENGTH = 16;
    private static final int IV_LENGTH = 12;
    private static final int KEY_LENGTH = 256;
    private static final String KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final int ITERATION_COUNT = 100000;
    private Cipher dcipher;
    private Cipher ecipher;
    private byte[] mSalt;
    private byte[] currentIV;
    private char[] passPhrase;
    private final SecureRandom secureRandom;

    public Aes256Encrypter(StringBuilder pPassPhrase) {
        this.passPhrase = new char[pPassPhrase.length()];
        pPassPhrase.getChars(0, this.passPhrase.length, this.passPhrase, 0);
        this.secureRandom = new SecureRandom();
        this.mSalt = new byte[16];
    }

    @Override
    public String decrypt(String str) {
        if (str == null) {
            return null;
        }
        try {
            String strippedPrefix = EncryptionHeader.stripPrefix(str);
            if (strippedPrefix == null) {
                return null;
            }
            byte[] allData = DesEncrypter.fromBase64(strippedPrefix);
            if (allData == null || allData.length < 28) {
                return null;
            }
            int offset = 0;
            byte[] salt = Arrays.copyOfRange(allData, offset, offset + 16);
            byte[] iv = Arrays.copyOfRange(allData, offset += 16, offset + 12);
            if (allData.length <= (offset += 12)) {
                return null;
            }
            byte[] ciphertext = Arrays.copyOfRange(allData, offset, allData.length);
            this.init(salt, iv);
            if (this.dcipher == null) {
                return null;
            }
            byte[] utf8 = this.dcipher.doFinal(ciphertext);
            return new String(utf8, StandardCharsets.UTF_8);
        }
        catch (AEADBadTagException aEADBadTagException) {
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String encrypt(String str) {
        try {
            this.initWithNewSalt();
            if (this.ecipher == null || this.currentIV == null) {
                return null;
            }
            byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
            byte[] enc = this.ecipher.doFinal(utf8);
            byte[] fullData = new byte[this.mSalt.length + this.currentIV.length + enc.length];
            int offset = 0;
            System.arraycopy(this.mSalt, 0, fullData, offset, this.mSalt.length);
            System.arraycopy(this.currentIV, 0, fullData, offset += this.mSalt.length, this.currentIV.length);
            System.arraycopy(enc, 0, fullData, offset += this.currentIV.length, enc.length);
            String base64Data = DesEncrypter.toBase64(fullData);
            return "FP-AES256-V1:" + base64Data;
        }
        catch (BadPaddingException e) {
            LogUtils.severe("AES-256 Encryption failed: bad padding", e);
        }
        catch (IllegalBlockSizeException e) {
            LogUtils.severe("AES-256 Encryption failed: illegal block size", e);
        }
        return null;
    }

    private void initWithNewSalt() {
        byte[] newSalt = new byte[16];
        this.secureRandom.nextBytes(newSalt);
        this.init(newSalt, null);
    }

    private void init(byte[] salt, byte[] iv) {
        boolean needsDecryptionInit;
        if (this.mSalt != null && salt != null && !Arrays.equals(this.mSalt, salt)) {
            this.ecipher = null;
            this.dcipher = null;
        }
        if (salt != null) {
            this.mSalt = salt;
        }
        boolean needsEncryptionInit = iv == null && this.ecipher == null;
        boolean bl = needsDecryptionInit = iv != null && this.dcipher == null;
        if (needsEncryptionInit || needsDecryptionInit) {
            try {
                PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase, this.mSalt, 100000, 256);
                SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_DERIVATION_ALGORITHM);
                SecretKey tmpKey = factory.generateSecret(keySpec);
                SecretKeySpec key = new SecretKeySpec(tmpKey.getEncoded(), "AES");
                if (iv == null) {
                    this.currentIV = new byte[12];
                    this.secureRandom.nextBytes(this.currentIV);
                    GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this.currentIV);
                    this.ecipher = Cipher.getInstance(CIPHER_ALGORITHM);
                    this.ecipher.init(1, (Key)key, gcmSpec);
                } else {
                    this.currentIV = iv;
                    GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this.currentIV);
                    this.dcipher = Cipher.getInstance(CIPHER_ALGORITHM);
                    this.dcipher.init(2, (Key)key, gcmSpec);
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                LogUtils.severe(e);
            }
            catch (InvalidKeySpecException e) {
                LogUtils.severe(e);
            }
            catch (NoSuchPaddingException e) {
                LogUtils.severe(e);
            }
            catch (NoSuchAlgorithmException e) {
                LogUtils.severe(e);
            }
            catch (InvalidKeyException e) {
                LogUtils.severe(e);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.passPhrase != null) {
            Arrays.fill(this.passPhrase, '\u0000');
            this.passPhrase = null;
        }
        if (this.mSalt != null) {
            Arrays.fill(this.mSalt, (byte)0);
            this.mSalt = null;
        }
        if (this.currentIV != null) {
            Arrays.fill(this.currentIV, (byte)0);
            this.currentIV = null;
        }
        this.ecipher = null;
        this.dcipher = null;
    }
}

