/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cart.CartFileSystem;
import ghidra.file.formats.cart.CartV1File;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CartFileSystemFactory
implements GFileSystemFactoryByteProvider<CartFileSystem>,
GFileSystemProbeByteProvider {
    public CartFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        CartFileSystem fs = null;
        try {
            fs = new CartFileSystem(targetFSRL, fsService);
            fs.mount(byteProvider, monitor);
            return fs;
        }
        catch (CancelledException | IOException e) {
            FSUtilities.uncheckedClose(fs, null);
            throw e;
        }
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        return CartV1File.isCart(byteProvider);
    }
}

