/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.util.Msg;
import java.io.IOException;

public class SquashFragment {
    private final long fragmentOffset;
    private final int header;
    private final int unusedField;

    public SquashFragment(BinaryReader reader) throws IOException {
        this.fragmentOffset = reader.readNextLong();
        this.header = reader.readNextInt();
        this.unusedField = reader.readNextInt();
    }

    public long getFragmentOffset() {
        return this.fragmentOffset;
    }

    public boolean isCompressed() {
        return (this.header & 0x1000000) == 0;
    }

    public long getFragmentSize() {
        return this.header & 0xFEFFFFFF;
    }

    public int getUnusedField() {
        if (this.unusedField != 0) {
            Msg.warn((Object)this, (Object)"Fragment has non-zero \"unused\" field");
        }
        return this.unusedField;
    }
}

