/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.app.plugin.core.decompiler.taint.sarif.SarifTaintGraphRunHandler;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import sarif.SarifService;

public abstract class TaintAbstractQueryAction
extends TaintAbstractDecompilerAction {
    protected TaintPlugin plugin;
    protected String desc;
    protected String title;
    protected String executeTaintQueryIconString;
    protected Icon executeTaintQueryIcon;
    protected TaintState.QueryType queryType;

    public TaintAbstractQueryAction(TaintPlugin plugin, String desc, String title, String cmd) {
        super(cmd);
        this.setHelpLocation(new HelpLocation("DecompilerTaint", "Taint" + desc));
        this.setMenuBarData(new MenuData(new String[]{"Source-Sink", this.getName()}));
        this.plugin = plugin;
        this.desc = desc;
        this.title = title;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return this.plugin.getTaintState() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        final Program program = context.getProgram();
        final PluginTool tool = context.getTool();
        Task defaultQueryTask = new Task(this.title, true, true, true, true){

            public void run(TaskMonitor monitor) {
                TaintState state = TaintAbstractQueryAction.this.plugin.getTaintState();
                state.setCancellation(false);
                monitor.initialize((long)program.getFunctionManager().getFunctionCount());
                state.queryIndex(program, tool, TaintAbstractQueryAction.this.queryType);
                state.setCancellation(monitor.isCancelled());
                monitor.clearCancelled();
            }
        };
        tool.execute(defaultQueryTask);
        TaintState state = this.plugin.getTaintState();
        if (!state.wasCancelled()) {
            TaintPlugin.TaintFormat format = state.getOptions().getTaintOutputForm();
            if (!format.equals((Object)TaintPlugin.TaintFormat.NONE)) {
                SarifService sarifService = this.plugin.getSarifService();
                sarifService.getController().setDefaultGraphHander(SarifTaintGraphRunHandler.class);
                sarifService.showSarif(this.desc, state.getData());
            }
            this.plugin.consoleMessage("executing query...");
            TaintProvider provider = this.plugin.getProvider();
            provider.setTaint();
            this.plugin.consoleMessage("query complete");
            state.setCancellation(false);
        } else {
            this.plugin.consoleMessage("Source-Sink query was cancelled.");
        }
    }
}

