/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift;

import ghidra.app.util.bin.format.swift.SwiftTypeMetadata;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledLabel;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.swift.SwiftDemangledTree;
import ghidra.app.util.demangler.swift.SwiftDemanglerOptions;
import ghidra.app.util.demangler.swift.SwiftNativeDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftDataTypeUtils;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwiftDemangler
implements Demangler {
    private Map<String, SwiftNode> cache;
    private SwiftTypeMetadata typeMetadata;
    private SwiftNativeDemangler nativeDemangler;
    private boolean is64bit = true;

    public SwiftDemangler() {
        try {
            this.initialize(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SwiftDemangler(Program program) throws IOException {
        this.initialize(program);
    }

    public boolean canDemangle(Program program) {
        return SwiftUtils.isSwift((Program)program);
    }

    public DemanglerOptions createDefaultOptions() {
        return new SwiftDemanglerOptions();
    }

    public void initialize(Program program) throws IOException {
        this.cache = new HashMap<String, SwiftNode>();
        this.nativeDemangler = null;
        try {
            if (program != null) {
                program.setPreferredRootNamespaceCategoryPath(SwiftDataTypeUtils.SWIFT_CATEGORY.getPath());
                this.typeMetadata = new SwiftTypeMetadata(program, TaskMonitor.DUMMY, new MessageLog());
                this.is64bit = program.getDefaultPointerSize() == 8;
            }
        }
        catch (CancelledException e) {
            return;
        }
    }

    public DemangledObject demangle(MangledContext context) throws DemangledException {
        DemangledFunction demangledObject;
        SwiftDemanglerOptions options = this.getSwiftDemanglerOptions(context.getOptions());
        String mangled = context.getMangled();
        Demangled demangled = this.getDemangled(mangled, options);
        if (demangled instanceof DemangledFunction) {
            DemangledFunction func;
            demangledObject = func = (DemangledFunction)demangled;
        } else if (demangled instanceof DemangledLabel) {
            DemangledLabel label = (DemangledLabel)demangled;
            demangledObject = label;
        } else if (demangled instanceof DemangledUnknown) {
            DemangledUnknown unknown = (DemangledUnknown)demangled;
            demangledObject = new DemangledLabel(mangled, unknown.getOriginalDemangled(), options.getUnsupportedPrefix() + unknown.getOriginalDemangled());
        } else {
            return null;
        }
        demangledObject.setMangledContext(context);
        return demangledObject;
    }

    public Demangled getDemangled(String mangled, SwiftDemanglerOptions op) throws DemangledException {
        if (!this.isSwiftMangledSymbol(mangled)) {
            return null;
        }
        SwiftDemanglerOptions options = this.getSwiftDemanglerOptions(op);
        this.setSwiftNativeDemangler(options);
        SwiftNode root = this.cache.containsKey(mangled) ? this.cache.get(mangled) : new SwiftDemangledTree(this.nativeDemangler, mangled, this.is64bit).getRoot();
        this.cache.put(mangled, root);
        if (root == null) {
            return null;
        }
        Demangled demangled = root.demangle(this);
        if (root.walkAndTest(node -> node.childWasSkipped())) {
            demangled.setName(options.getIncompletePrefix() + demangled.getName());
        }
        return demangled;
    }

    public SwiftTypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    public boolean isSwiftMangledSymbol(String symbolName) {
        List<String> prefixes = List.of("$S", "$s", "_$S", "_$s", "_T");
        return prefixes.stream().anyMatch(prefix -> symbolName.startsWith((String)prefix));
    }

    public SwiftDemanglerOptions getSwiftDemanglerOptions(DemanglerOptions opt) throws DemangledException {
        if (!(opt instanceof SwiftDemanglerOptions)) {
            opt = this.createDefaultOptions();
        }
        return (SwiftDemanglerOptions)opt;
    }

    private void setSwiftNativeDemangler(SwiftDemanglerOptions options) throws DemangledException {
        if (this.nativeDemangler == null) {
            try {
                this.nativeDemangler = new SwiftNativeDemangler(options.getSwiftDir());
            }
            catch (IOException e) {
                throw new DemangledException((Exception)e);
            }
        }
    }
}

