/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

class ThreadUnsafeWeakSet<T>
extends WeakSet<T> {
    ThreadUnsafeWeakSet() {
    }

    @Override
    public boolean add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        boolean contains = this.weakHashStorage.containsKey(t);
        this.weakHashStorage.put(t, null);
        return !contains;
    }

    @Override
    public boolean remove(Object t) {
        boolean contains = this.weakHashStorage.containsKey(t);
        this.weakHashStorage.remove(t);
        return contains;
    }

    @Override
    public void clear() {
        this.weakHashStorage.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.weakHashStorage.keySet().iterator();
    }

    @Override
    public Collection<T> values() {
        return this.weakHashStorage.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public boolean contains(Object t) {
        return this.weakHashStorage.containsKey(t);
    }

    public String toString() {
        return this.weakHashStorage.toString();
    }

    @Override
    public Stream<T> stream() {
        return this.values().stream();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T t : c) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            T t = it.next();
            if (c.contains(t)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.weakHashStorage.keySet().removeAll(c);
    }
}

