/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.map;

import ghidra.util.map.ValueMap;
import ghidra.util.map.ValueStoragePage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectValueMap<T>
extends ValueMap<T> {
    public ObjectValueMap(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 20;
    }

    public void putObject(long index, T value) {
        ValueStoragePage<T> page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addObject(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public T getObject(long index) {
        ValueStoragePage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getObject(this.getPageOffset(index));
        }
        return null;
    }

    @Override
    protected void moveIndex(long from, long to) {
        T value = this.getObject(from);
        this.remove(from);
        this.putObject(to, value);
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        oos.writeObject(this.getObject(index));
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException, ClassNotFoundException {
        this.putObject(index, ois.readObject());
    }
}

