/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.guest;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.Collection;

public interface TracePlatform {
    public Trace getTrace();

    public boolean isGuest();

    default public boolean isHost() {
        return !this.isGuest();
    }

    public Language getLanguage();

    default public AddressFactory getAddressFactory() {
        return this.getLanguage().getAddressFactory();
    }

    public CompilerSpec getCompilerSpec();

    public TraceBasedDataTypeManager getDataTypeManager();

    public AddressSetView getHostAddressSet();

    public AddressSetView getGuestAddressSet();

    public Address mapHostToGuest(Address var1);

    public AddressRange mapHostToGuest(AddressRange var1);

    public AddressSetView mapHostToGuest(AddressSetView var1);

    public Address mapGuestToHost(Address var1);

    public AddressRange mapGuestToHost(AddressRange var1);

    public AddressSetView mapGuestToHost(AddressSetView var1);

    public AddressRange getConventionalRegisterRange(AddressSpace var1, Register var2);

    public Collection<String> getConventionalRegisterObjectNames(Register var1);

    public PathFilter getConventionalRegisterPath(TraceObjectSchema var1, KeyPath var2, Collection<String> var3);

    public PathFilter getConventionalRegisterPath(TraceObjectSchema var1, KeyPath var2, Register var3);

    public PathFilter getConventionalRegisterPath(TraceObject var1, Register var2);

    public PathFilter getConventionalRegisterPath(AddressSpace var1, Register var2);

    public TraceLabelSymbol addRegisterMapOverride(Register var1, String var2);

    public MemBuffer getMappedMemBuffer(long var1, Address var3);

    public InstructionSet mapGuestInstructionAddressesToHost(InstructionSet var1);
}

