/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.codebrowser.AddressRangeBytesTableColumn;
import ghidra.app.plugin.core.codebrowser.AddressRangeCodeUnitTableColumn;
import ghidra.app.plugin.core.codebrowser.AddressRangeInfo;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.stream.StreamSupport;

public class AddressRangeTableModel
extends GhidraProgramTableModel<AddressRangeInfo> {
    private static final int MIN_ADDRESS_COLUMN_INDEX = 0;
    private static final int MAX_ADDRESS_COLUMN_INDEX = 1;
    private ProgramSelection selection;
    private int resultsLimit;
    private long minLength;

    protected AddressRangeTableModel(PluginTool tool, Program program, ProgramSelection selection, int resultsLimit, long minLength) {
        super("Selected Ranges in " + program.getName(), (ServiceProvider)tool, program, null);
        this.selection = selection;
        this.resultsLimit = resultsLimit;
        this.minLength = minLength;
    }

    protected void doLoad(Accumulator<AddressRangeInfo> accumulator, TaskMonitor monitor) throws CancelledException {
        AddressRangeIterator rangeIter = this.selection.getAddressRanges();
        ReferenceManager refManager = this.program.getReferenceManager();
        while (rangeIter.hasNext()) {
            monitor.checkCancelled();
            AddressRange range = (AddressRange)rangeIter.next();
            if (range.getLength() < this.minLength) continue;
            boolean isSameByte = AddressRangeInfo.isSameByteValue(range.getMinAddress(), range.getMaxAddress(), this.program);
            AddressSet rangeSet = new AddressSet(range);
            AddressIterator destAddrIter = refManager.getReferenceDestinationIterator((AddressSetView)rangeSet, true);
            int numRefsTo = StreamSupport.stream(destAddrIter.spliterator(), false).map(addr -> refManager.getReferenceCountTo(addr)).reduce(0, Integer::sum);
            AddressIterator srcAddrIter = refManager.getReferenceSourceIterator((AddressSetView)rangeSet, true);
            int numRefsFrom = StreamSupport.stream(srcAddrIter.spliterator(), false).map(addr -> refManager.getReferenceCountFrom(addr)).reduce(0, Integer::sum);
            AddressRangeInfo info = new AddressRangeInfo(range.getMinAddress(), range.getMaxAddress(), range.getLength(), isSameByte, numRefsTo, numRefsFrom);
            accumulator.add((Object)info);
            if (accumulator.size() < this.resultsLimit) continue;
            Msg.showWarn((Object)this, null, (String)"Results Truncated", (Object)("Results are limited to " + this.resultsLimit + " address ranges.\nThis limit can be changed by the tool option \"Selection Tables -> Ranges From Selection Limit\"."));
            break;
        }
        if (accumulator.isEmpty()) {
            Msg.showWarn((Object)this, null, (String)"No Ranges to Display", (Object)"No ranges to display - consider adjusting \"Selection Tables -> Minimum Length of Address Range in Range Table\".");
        }
    }

    public void refresh() {
        this.reload();
    }

    @Override
    protected TableColumnDescriptor<AddressRangeInfo> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new MinAddressTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new MaxAddressTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new LengthTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new IdenticalBytesTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new NumRefsToTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new NumRefsFromTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new BlockNameTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AddressRangeBytesTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AddressRangeCodeUnitTableColumn());
        return descriptor;
    }

    @Override
    public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
        AddressRangeInfo rangeInfo = (AddressRangeInfo)this.getRowObject(modelRow);
        if (modelColumn == 1) {
            return new ProgramLocation(this.program, rangeInfo.max());
        }
        return new ProgramLocation(this.program, rangeInfo.min());
    }

    @Override
    public ProgramSelection getProgramSelection(int[] modelRows) {
        AddressSet ranges = new AddressSet();
        for (AddressRangeInfo rangeInfo : this.getRowObjects(modelRows)) {
            ranges.addRange(this.program, rangeInfo.min(), rangeInfo.max());
        }
        return new ProgramSelection((AddressSetView)ranges);
    }

    @Override
    public Address getAddress(int modelRow) {
        AddressRangeInfo rangeInfo = (AddressRangeInfo)this.getRowObject(modelRow);
        return rangeInfo.min();
    }

    @Override
    public Address getAddress(int modelRow, int modelColumn) {
        AddressRangeInfo rangeInfo = (AddressRangeInfo)this.getRowObject(modelRow);
        if (modelColumn == 0) {
            return rangeInfo.min();
        }
        if (modelColumn == 1) {
            return rangeInfo.max();
        }
        return null;
    }

    private class MinAddressTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, Address, Object> {
        private MinAddressTableColumn(AddressRangeTableModel addressRangeTableModel) {
        }

        public String getColumnName() {
            return "Min Address";
        }

        public Address getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rangeInfo.min();
        }
    }

    private class MaxAddressTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, Address, Object> {
        private MaxAddressTableColumn(AddressRangeTableModel addressRangeTableModel) {
        }

        public String getColumnName() {
            return "Max Address";
        }

        public Address getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rangeInfo.max();
        }
    }

    private class LengthTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, Long, Object> {
        private LengthTableColumn(AddressRangeTableModel addressRangeTableModel) {
        }

        public String getColumnName() {
            return "Length";
        }

        public Long getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rangeInfo.size();
        }
    }

    private class IdenticalBytesTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, Boolean, Object> {
        private IdenticalBytesTableColumn(AddressRangeTableModel addressRangeTableModel) {
        }

        public String getColumnName() {
            return "Identical Bytes";
        }

        public String getColumnDescription() {
            return "Do all bytes in the range have the same value";
        }

        public Boolean getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rangeInfo.isSameByte();
        }
    }

    private class NumRefsToTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, Integer, Object> {
        private NumRefsToTableColumn(AddressRangeTableModel addressRangeTableModel) {
        }

        public String getColumnName() {
            return "To References";
        }

        public Integer getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rangeInfo.numRefsTo();
        }
    }

    private class NumRefsFromTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, Integer, Object> {
        private NumRefsFromTableColumn(AddressRangeTableModel addressRangeTableModel) {
        }

        public String getColumnName() {
            return "From References";
        }

        public Integer getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rangeInfo.numRefsFrom();
        }
    }

    private class BlockNameTableColumn
    extends AbstractDynamicTableColumn<AddressRangeInfo, String, Object> {
        private BlockNameTableColumn() {
        }

        public String getColumnName() {
            return "Block Name";
        }

        public String getValue(AddressRangeInfo rangeInfo, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return AddressRangeTableModel.this.program.getMemory().getBlock(rangeInfo.min()).getName();
        }
    }
}

