/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

class Hcs12DisassembleAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;
    private boolean disassembleXgate = false;

    public Hcs12DisassembleAction(DisassemblerPlugin plugin, String groupName, boolean disassembleXgate) {
        super("Disassemble " + (disassembleXgate ? "HCS12" : "XGate"), plugin.getName());
        this.plugin = plugin;
        this.disassembleXgate = disassembleXgate;
        HelpLocation location = new HelpLocation("DisassemblerPlugin", "Disassemble");
        this.setHelpLocation(location);
        this.setPopupMenuData(new MenuData(new String[]{"Disassemble - " + (disassembleXgate ? "XGate" : "HCS12")}, null, groupName));
        int keyEvent = disassembleXgate ? 123 : 122;
        this.setKeyBindingData(new KeyBindingData(keyEvent, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.disassembleHcs12Callback(context, this.disassembleXgate);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Language lang = program.getLanguage();
        Processor proc = lang.getProcessor();
        if (!"HCS12".equals(proc.toString())) {
            return false;
        }
        Register register = context.getProgram().getProgramContext().getRegister("XGATE");
        if (register == null) {
            return false;
        }
        return this.plugin.checkDisassemblyEnabled(context, address, true);
    }
}

