/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CliStreamGuid
extends CliAbstractStream {
    private int numGuids;

    public static String getName() {
        return "#GUID";
    }

    public CliStreamGuid(CliStreamHeader header, long offset, int rva, BinaryReader reader) throws IOException {
        super(header, offset, rva, reader);
        this.numGuids = header.getSize() / 16;
    }

    @Override
    public boolean parse() throws IOException {
        return true;
    }

    public GUID getGuid(int index) {
        if (index < 0 || index >= this.numGuids * 16) {
            return null;
        }
        try {
            this.reader.setPointerIndex(this.offset + (long)index);
            return new GUID(this.reader);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Streams"), this.header.getName(), 0);
        GuidDataType guidDT = new GuidDataType();
        for (int i = 0; i < this.numGuids; ++i) {
            struct.add((DataType)guidDT, "[" + Integer.toHexString(i) + "]", null);
        }
        return struct;
    }
}

