/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.GProperties;

public class ArrayElementWrappedOption
implements CustomOption {
    private static final String SHOW_MULTI_ELEMENTS_PER_LINE = "showMultiArrayElementsPerLine";
    private static final String ELEMENTS_PER_LINE = "elementsPerLine";
    private static final boolean DEFAULT_SHOW_MULTI = true;
    private static final int DEFAULT_ELEMENTS_PER_LINE = 4;
    private boolean showMultipleArrayElementPerLine = true;
    private int arrayElementsPerLine = 4;

    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayElementWrappedOption)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ArrayElementWrappedOption otherOption = (ArrayElementWrappedOption)obj;
        return this.showMultipleArrayElementPerLine == otherOption.showMultipleArrayElementPerLine && this.arrayElementsPerLine == otherOption.arrayElementsPerLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.showMultipleArrayElementPerLine ? 1 : 0);
        result = prime * result + this.arrayElementsPerLine;
        return result;
    }

    public void readState(GProperties properties) {
        this.showMultipleArrayElementPerLine = properties.getBoolean(SHOW_MULTI_ELEMENTS_PER_LINE, true);
        this.arrayElementsPerLine = properties.getInt(ELEMENTS_PER_LINE, 4);
    }

    public void writeState(GProperties properties) {
        properties.putBoolean(SHOW_MULTI_ELEMENTS_PER_LINE, this.showMultipleArrayElementPerLine);
        properties.putInt(ELEMENTS_PER_LINE, this.arrayElementsPerLine);
    }

    public boolean showMultipleArrayElementPerLine() {
        return this.showMultipleArrayElementPerLine;
    }

    public void setShowMultipleArrayElementPerLine(boolean b) {
        this.showMultipleArrayElementPerLine = b;
    }

    public int getArrayElementsPerLine() {
        return this.arrayElementsPerLine;
    }

    public void setArrayElementsPerLine(int arrayElementsPerLine) {
        if (arrayElementsPerLine <= 0) {
            arrayElementsPerLine = 1;
        }
        this.arrayElementsPerLine = arrayElementsPerLine;
    }
}

