/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.spatial.hyper.Dimension;
import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperPoint;
import java.util.List;
import java.util.Objects;

public interface EuclideanHyperSpace<P extends HyperPoint, B extends HyperBox<P, B>> {
    public List<Dimension<?, P, B>> getDimensions();

    public B getFull();

    default public boolean boxesEqual(B a, B b) {
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            if (!Objects.equals(dim.lower(a), dim.lower(b))) {
                return false;
            }
            if (Objects.equals(dim.upper(a), dim.upper(b))) continue;
            return false;
        }
        return true;
    }

    default public Object[] collectBounds(B box) {
        List<Dimension<?, P, B>> dims = this.getDimensions();
        Object[] result = new Object[dims.size() * 2];
        for (int i = 0; i < dims.size(); ++i) {
            Dimension<?, P, B> d = dims.get(i);
            result[i * 2] = d.lower(box);
            result[i * 2 + 1] = d.upper(box);
        }
        return result;
    }

    default public boolean boxContains(B box, P point) {
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            if (dim.contains(box, point)) continue;
            return false;
        }
        return true;
    }

    default public double boxArea(B box) {
        double result = 1.0;
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            result *= 1.0 + dim.measure(box);
        }
        return result;
    }

    default public double boxMargin(B box) {
        double result = 0.0;
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            result += 1.0 + dim.measure(box);
        }
        return result;
    }

    public P boxCenter(B var1);

    default public <T> double measureUnion(Dimension<T, P, B> dim, B a, B b) {
        T unionLower = dim.unionLower(a, b);
        T unionUpper = dim.unionUpper(a, b);
        return dim.distance(unionUpper, unionLower);
    }

    default public double computeAreaUnionBounds(B a, B b) {
        double result = 1.0;
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            result *= 1.0 + this.measureUnion(dim, a, b);
        }
        return result;
    }

    default public <T> double measureIntersection(Dimension<T, P, B> dim, B a, B b) {
        T intUpper;
        T intLower = dim.intersectionLower(a, b);
        if (dim.compare(intLower, intUpper = dim.intersectionUpper(a, b)) > 0) {
            return 0.0;
        }
        return dim.distance(intUpper, intLower);
    }

    default public double computeAreaIntersection(B a, B b) {
        double result = 1.0;
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            double measure = this.measureIntersection(dim, a, b);
            if (measure == 0.0) {
                return 0.0;
            }
            result *= 1.0 + measure;
        }
        return result;
    }

    default public double sqDistance(P a, P b) {
        double result = 0.0;
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            double dist = dim.pointDistance(a, b);
            result += dist * dist;
        }
        return result;
    }

    public B boxUnionBounds(B var1, B var2);

    public B boxIntersection(B var1, B var2);

    default public boolean boxEncloses(B outer, B inner) {
        for (Dimension<?, P, B> dim : this.getDimensions()) {
            if (dim.encloses(outer, inner)) continue;
            return false;
        }
        return true;
    }
}

