/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.LayoutDecorator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.util.Caching;
import java.awt.geom.Point2D;

public class CachingLayout<V, E>
extends LayoutDecorator<V, E>
implements Caching {
    protected LoadingCache<V, Point2D> locations;

    public CachingLayout(Layout<V, E> delegate) {
        super(delegate);
        Function chain = Functions.compose((Function)new Function<Point2D, Point2D>(){

            public Point2D apply(Point2D p) {
                return (Point2D)p.clone();
            }
        }, delegate);
        this.locations = CacheBuilder.newBuilder().build(CacheLoader.from((Function)chain));
    }

    public void setGraph(Graph<V, E> graph) {
        this.delegate.setGraph(graph);
    }

    @Override
    public void clear() {
        this.locations = CacheBuilder.newBuilder().build(new CacheLoader<V, Point2D>(){

            public Point2D load(V vertex) {
                return new Point2D.Double();
            }
        });
    }

    @Override
    public void init() {
    }

    public Point2D apply(V v) {
        return (Point2D)this.locations.getUnchecked(v);
    }
}

