/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpattern;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpattern.CombinePattern;
import ghidra.pcodeCPort.slghpattern.ContextPattern;
import ghidra.pcodeCPort.slghpattern.DisjointPattern;
import ghidra.pcodeCPort.slghpattern.OrPattern;
import ghidra.pcodeCPort.slghpattern.Pattern;
import ghidra.pcodeCPort.slghpattern.PatternBlock;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class InstructionPattern
extends DisjointPattern {
    private PatternBlock maskvalue;

    @Override
    public String toString() {
        return "InstructionPattern{" + this.maskvalue.toString() + "}";
    }

    @Override
    protected PatternBlock getBlock(boolean context) {
        return context ? null : this.maskvalue;
    }

    public InstructionPattern() {
        this.maskvalue = null;
    }

    public InstructionPattern(PatternBlock mv) {
        this.maskvalue = mv;
    }

    public InstructionPattern(boolean tf) {
        this.maskvalue = new PatternBlock(tf);
    }

    public PatternBlock getBlock() {
        return this.maskvalue;
    }

    @Override
    public void dispose() {
        if (this.maskvalue != null) {
            this.maskvalue.dispose();
        }
    }

    @Override
    public Pattern simplifyClone() {
        return new InstructionPattern(this.maskvalue.clone());
    }

    @Override
    public void shiftInstruction(int sa) {
        this.maskvalue.shift(sa);
    }

    @Override
    public boolean alwaysTrue() {
        return this.maskvalue.alwaysTrue();
    }

    @Override
    public boolean alwaysFalse() {
        return this.maskvalue.alwaysFalse();
    }

    @Override
    public boolean alwaysInstructionTrue() {
        return this.maskvalue.alwaysTrue();
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        PatternBlock respattern;
        if (b.numDisjoint() > 0) {
            return b.doAnd(this, -sa);
        }
        if (b instanceof CombinePattern) {
            return b.doAnd(this, -sa);
        }
        if (b instanceof ContextPattern) {
            ContextPattern b3 = (ContextPattern)b;
            InstructionPattern newpat = (InstructionPattern)this.simplifyClone();
            if (sa < 0) {
                newpat.shiftInstruction(-sa);
            }
            return new CombinePattern((ContextPattern)b3.simplifyClone(), newpat);
        }
        InstructionPattern b4 = (InstructionPattern)b;
        if (sa < 0) {
            PatternBlock a = this.maskvalue.clone();
            a.shift(-sa);
            respattern = a.intersect(b4.maskvalue);
            a.dispose();
        } else {
            PatternBlock c = b4.maskvalue.clone();
            c.shift(sa);
            respattern = this.maskvalue.intersect(c);
            c.dispose();
        }
        return new InstructionPattern(respattern);
    }

    @Override
    public Pattern commonSubPattern(Pattern b, int sa) {
        PatternBlock respattern;
        if (b.numDisjoint() > 0) {
            return b.commonSubPattern(this, -sa);
        }
        if (b instanceof CombinePattern) {
            return b.commonSubPattern(this, -sa);
        }
        if (b instanceof ContextPattern) {
            return new InstructionPattern(true);
        }
        InstructionPattern b4 = (InstructionPattern)b;
        if (sa < 0) {
            PatternBlock a = this.maskvalue.clone();
            a.shift(-sa);
            respattern = a.commonSubPattern(b4.maskvalue);
            a.dispose();
        } else {
            PatternBlock c = b4.maskvalue.clone();
            c.shift(sa);
            respattern = this.maskvalue.commonSubPattern(c);
            c.dispose();
        }
        return new InstructionPattern(respattern);
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        if (b.numDisjoint() > 0) {
            return b.doOr(this, -sa);
        }
        if (b instanceof CombinePattern) {
            return b.doOr(this, -sa);
        }
        DisjointPattern res1 = (DisjointPattern)this.simplifyClone();
        DisjointPattern res2 = (DisjointPattern)b.simplifyClone();
        if (sa < 0) {
            res1.shiftInstruction(-sa);
        } else {
            res2.shiftInstruction(sa);
        }
        return new OrPattern(res1, res2);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_INSTRUCT_PAT);
        this.maskvalue.encode(encoder);
        encoder.closeElement(SlaFormat.ELEM_INSTRUCT_PAT);
    }
}

