/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.QualifierFilter;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class AndFilter
implements QualifierFilter {
    private QualifierFilter[] subQualifiers;

    public AndFilter(ArrayList<QualifierFilter> qualifierList) {
        this.subQualifiers = new QualifierFilter[qualifierList.size()];
        qualifierList.toArray(this.subQualifiers);
    }

    public AndFilter(AndFilter op) {
        this.subQualifiers = new QualifierFilter[op.subQualifiers.length];
        for (int i = 0; i < this.subQualifiers.length; ++i) {
            this.subQualifiers[i] = op.subQualifiers[i].clone();
        }
    }

    @Override
    public QualifierFilter clone() {
        return new AndFilter(this);
    }

    @Override
    public boolean isEquivalent(QualifierFilter op) {
        if (op.getClass() != this.getClass()) {
            return false;
        }
        AndFilter otherFilter = (AndFilter)op;
        if (this.subQualifiers.length != otherFilter.subQualifiers.length) {
            return false;
        }
        for (int i = 0; i < this.subQualifiers.length; ++i) {
            if (this.subQualifiers[i].isEquivalent(otherFilter.subQualifiers[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean filter(PrototypePieces proto, int pos) {
        for (int i = 0; i < this.subQualifiers.length; ++i) {
            if (this.subQualifiers[i].filter(proto, pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        for (int i = 0; i < this.subQualifiers.length; ++i) {
            this.subQualifiers[i].encode(encoder);
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
    }
}

