/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.viewer.field;

/**
 * This implementation expands {@link URLAnnotatedStringHandler} providing an example form
 * of a Ghidra Server URL.
 */
public class GhidraServerURLAnnotatedStringHandler extends URLAnnotatedStringHandler {

	@Override
	public String getDisplayString() {
		return "Ghidra-URL(remote)";
	}

	@Override
	public String getPrototypeString() {
		return "{@url \"ghidra://myserver/myrepo/folder/program.exe#symbol\" \"display string\"}";
	}

}
