/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.testcode.editgpt;

import org.catacombae.csjc.structelements.Field;
import org.catacombae.csjc.structelements.StringRepresentableField;

/**
 *
 * @author  Erik
 */
public class EditStringValuePanel extends javax.swing.JPanel {
    private StringRepresentableField userData;
    private String originalValue;
    
    /** Creates new form EditStringValuePanel */
    public EditStringValuePanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        contentsField = new javax.swing.JTextField();
        lockedCheckbox = new javax.swing.JCheckBox();
        descriptionLabel = new javax.swing.JLabel();

        contentsField.setColumns(9);
        contentsField.setEditable(false);
        contentsField.setText("jTextField1");

        lockedCheckbox.setSelected(true);
        lockedCheckbox.setText("Lock");
        lockedCheckbox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lockedCheckboxActionPerformed(evt);
            }
        });

        descriptionLabel.setText("jLabel1");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(descriptionLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(contentsField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 362, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lockedCheckbox))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(descriptionLabel)
                .add(contentsField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(lockedCheckbox))
        );
    }// </editor-fold>//GEN-END:initComponents

private void lockedCheckboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lockedCheckboxActionPerformed
    if(lockedCheckbox.isSelected())
        contentsField.setEditable(false);
    else
        contentsField.setEditable(true);
}//GEN-LAST:event_lockedCheckboxActionPerformed
    
    public String getDescription() {
        return descriptionLabel.getText();
    }

    public void setDecription(String s) {
        descriptionLabel.setText(s);
    }
    
    public void setValue(String value) {
        contentsField.setText(value);
        this.originalValue = value;
    }
    
    public String getValue() {
        return contentsField.getText();
    }
    
    public boolean isModified() {
        return !contentsField.getText().equals(originalValue);
    }
    
    public void setUserData(StringRepresentableField data) {
        this.userData = data;
    }
    
    public StringRepresentableField getUserData() {
        return userData;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField contentsField;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JCheckBox lockedCheckbox;
    // End of variables declaration//GEN-END:variables

}
