/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinToJvmSignatureMapper;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturePropagationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class SignaturesPropagationData {
    private static final KotlinToJvmSignatureMapper SIGNATURE_MAPPER = ServiceLoader.load(KotlinToJvmSignatureMapper.class, KotlinToJvmSignatureMapper.class.getClassLoader()).iterator().next();
    private final ValueParameters modifiedValueParameters;
    private final List<String> signatureErrors;
    private final List<FunctionDescriptor> superFunctions;

    public SignaturesPropagationData(@NotNull ClassDescriptor containingClass, @NotNull KotlinType autoReturnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters, @NotNull JavaMethod method) {
        if (containingClass == null) {
            SignaturesPropagationData.$$$reportNull$$$0(0);
        }
        if (autoReturnType == null) {
            SignaturesPropagationData.$$$reportNull$$$0(1);
        }
        if (autoValueParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(2);
        }
        if (autoTypeParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(3);
        }
        if (method == null) {
            SignaturesPropagationData.$$$reportNull$$$0(4);
        }
        this.signatureErrors = new ArrayList<String>(0);
        assert (receiverType == null) : "Parameters before propagation have receiver type, but propagation should be disabled for functions compiled from Kotlin in class: " + DescriptorUtils.getFqName(containingClass);
        JavaMethodDescriptor autoMethodDescriptor = SignaturesPropagationData.createAutoMethodDescriptor(containingClass, method, autoReturnType, autoValueParameters, autoTypeParameters);
        this.superFunctions = SignaturesPropagationData.getSuperFunctionsForMethod(method, autoMethodDescriptor, containingClass);
        this.modifiedValueParameters = this.superFunctions.isEmpty() ? new ValueParameters(null, autoValueParameters, false) : this.modifyValueParametersAccordingToSuperMethods(autoValueParameters);
    }

    @NotNull
    private static JavaMethodDescriptor createAutoMethodDescriptor(@NotNull ClassDescriptor containingClass, @NotNull JavaMethod method, KotlinType autoReturnType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters) {
        if (containingClass == null) {
            SignaturesPropagationData.$$$reportNull$$$0(5);
        }
        if (method == null) {
            SignaturesPropagationData.$$$reportNull$$$0(6);
        }
        if (autoValueParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(7);
        }
        if (autoTypeParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(8);
        }
        JavaMethodDescriptor autoMethodDescriptor = JavaMethodDescriptor.createJavaMethod(containingClass, Annotations.Companion.getEMPTY(), method.getName(), SourceElement.NO_SOURCE, false);
        autoMethodDescriptor.initialize((ReceiverParameterDescriptor)null, containingClass.getThisAsReceiverParameter(), CollectionsKt.emptyList(), autoTypeParameters, (List)autoValueParameters, autoReturnType, Modality.OPEN, DescriptorVisibilities.PUBLIC);
        JavaMethodDescriptor javaMethodDescriptor = autoMethodDescriptor;
        if (javaMethodDescriptor == null) {
            SignaturesPropagationData.$$$reportNull$$$0(9);
        }
        return javaMethodDescriptor;
    }

    public KotlinType getModifiedReceiverType() {
        return this.modifiedValueParameters.receiverType;
    }

    public List<ValueParameterDescriptor> getModifiedValueParameters() {
        return this.modifiedValueParameters.descriptors;
    }

    public boolean getModifiedHasStableParameterNames() {
        return this.modifiedValueParameters.hasStableParameterNames;
    }

    public List<String> getSignatureErrors() {
        return this.signatureErrors;
    }

    void reportError(String error) {
        this.signatureErrors.add(error);
    }

    private ValueParameters modifyValueParametersAccordingToSuperMethods(@NotNull List<ValueParameterDescriptor> parameters) {
        if (parameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(10);
        }
        KotlinType resultReceiverType = null;
        ArrayList<ValueParameterDescriptor> resultParameters = new ArrayList<ValueParameterDescriptor>(parameters.size());
        boolean shouldBeExtension = this.checkIfShouldBeExtension();
        for (ValueParameterDescriptor originalParam : parameters) {
            int originalIndex = originalParam.getIndex();
            List typesFromSuperMethods = CollectionsKt.map(this.superFunctions, superFunction -> {
                int index;
                ReceiverParameterDescriptor receiver = superFunction.getExtensionReceiverParameter();
                int n2 = index = receiver != null ? originalIndex - 1 : originalIndex;
                if (index == -1) {
                    assert (receiver != null) : "can't happen: index is -1, while function is not extension";
                    return new TypeAndName(receiver.getType(), originalParam.getName());
                }
                ValueParameterDescriptor parameter = superFunction.getValueParameters().get(index);
                return new TypeAndName(parameter.getType(), parameter.getName());
            });
            VarargCheckResult varargCheckResult = this.checkVarargInSuperFunctions(originalParam);
            KotlinType altType = varargCheckResult.parameterType;
            if (shouldBeExtension && originalIndex == 0) {
                resultReceiverType = altType;
                continue;
            }
            Name stableName = null;
            for (int i2 = 0; i2 < this.superFunctions.size(); ++i2) {
                if (!this.superFunctions.get(i2).hasStableParameterNames()) continue;
                stableName = ((TypeAndName)typesFromSuperMethods.get((int)i2)).name;
                break;
            }
            resultParameters.add(new ValueParameterDescriptorImpl(originalParam.getContainingDeclaration(), null, shouldBeExtension ? originalIndex - 1 : originalIndex, originalParam.getAnnotations(), stableName != null ? stableName : originalParam.getName(), altType, originalParam.declaresDefaultValue(), originalParam.isCrossinline(), originalParam.isNoinline(), varargCheckResult.isVararg ? DescriptorUtilsKt.getBuiltIns(originalParam).getArrayElementType(altType) : null, SourceElement.NO_SOURCE));
        }
        boolean hasStableParameterNames = CollectionsKt.any(this.superFunctions, CallableDescriptor::hasStableParameterNames);
        return new ValueParameters(resultReceiverType, resultParameters, hasStableParameterNames);
    }

    private static List<FunctionDescriptor> getSuperFunctionsForMethod(@NotNull JavaMethod method, @NotNull JavaMethodDescriptor autoMethodDescriptor, @NotNull ClassDescriptor containingClass) {
        if (method == null) {
            SignaturesPropagationData.$$$reportNull$$$0(11);
        }
        if (autoMethodDescriptor == null) {
            SignaturesPropagationData.$$$reportNull$$$0(12);
        }
        if (containingClass == null) {
            SignaturesPropagationData.$$$reportNull$$$0(13);
        }
        ArrayList<FunctionDescriptor> superFunctions = Lists.newArrayList();
        Name name2 = method.getName();
        KotlinToJvmSignatureMapper.MethodSignature autoSignature = null;
        boolean autoMethodContainsVararg = SignaturePropagationUtilKt.containsVarargs(autoMethodDescriptor);
        for (KotlinType supertype : containingClass.getTypeConstructor().getSupertypes()) {
            Collection<? extends SimpleFunctionDescriptor> superFunctionCandidates = supertype.getMemberScope().getContributedFunctions(name2, NoLookupLocation.WHEN_GET_SUPER_MEMBERS);
            if (!autoMethodContainsVararg && !SignaturePropagationUtilKt.containsAnyNotTrivialSignature(superFunctionCandidates)) continue;
            if (autoSignature == null) {
                autoSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(autoMethodDescriptor);
            }
            for (FunctionDescriptor functionDescriptor : superFunctionCandidates) {
                KotlinToJvmSignatureMapper.MethodSignature candidateSignature;
                if (functionDescriptor.isSuspend() || !SIGNATURE_MAPPER.erasedSignaturesEqualIgnoringReturnTypes(autoSignature, candidateSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(functionDescriptor))) continue;
                superFunctions.add(functionDescriptor);
            }
        }
        superFunctions.sort(Comparator.comparing(fun -> DescriptorUtils.getFqName(fun.getContainingDeclaration()).asString()));
        return superFunctions;
    }

    private boolean checkIfShouldBeExtension() {
        boolean someSupersExtension = false;
        boolean someSupersNotExtension = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            if (superFunction.getExtensionReceiverParameter() != null) {
                someSupersExtension = true;
                continue;
            }
            someSupersNotExtension = true;
        }
        if (someSupersExtension) {
            if (someSupersNotExtension) {
                this.reportError("Incompatible super methods: some are extension functions, some are not");
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private VarargCheckResult checkVarargInSuperFunctions(@NotNull ValueParameterDescriptor originalParam) {
        if (originalParam == null) {
            SignaturesPropagationData.$$$reportNull$$$0(14);
        }
        boolean someSupersVararg = false;
        boolean someSupersNotVararg = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            int index;
            int originalIndex = originalParam.getIndex();
            int n2 = index = superFunction.getExtensionReceiverParameter() != null ? originalIndex - 1 : originalIndex;
            if (index != -1 && superFunction.getValueParameters().get(index).getVarargElementType() != null) {
                someSupersVararg = true;
                continue;
            }
            someSupersNotVararg = true;
        }
        KotlinType originalVarargElementType = originalParam.getVarargElementType();
        KotlinType originalType = originalParam.getType();
        if (someSupersVararg && someSupersNotVararg) {
            this.reportError("Incompatible super methods: some have vararg parameter, some have not");
            return new VarargCheckResult(originalType, originalVarargElementType != null);
        }
        if (someSupersVararg && originalVarargElementType == null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            return new VarargCheckResult(TypeUtils.makeNotNullable(originalType), true);
        }
        if (someSupersNotVararg && originalVarargElementType != null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            return new VarargCheckResult(TypeUtils.makeNullable(originalType), false);
        }
        return new VarargCheckResult(originalType, originalVarargElementType != null);
    }

    private static boolean isArrayType(@NotNull KotlinType type) {
        if (type == null) {
            SignaturesPropagationData.$$$reportNull$$$0(15);
        }
        return KotlinBuiltIns.isArray(type) || KotlinBuiltIns.isPrimitiveArray(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoReturnType";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoValueParameters";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoTypeParameters";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoMethodDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalParam";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAutoMethodDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAutoMethodDescriptor";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modifyValueParametersAccordingToSuperMethods";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperFunctionsForMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkVarargInSuperFunctions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isArrayType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ValueParameters {
        private final KotlinType receiverType;
        private final List<ValueParameterDescriptor> descriptors;
        private final boolean hasStableParameterNames;

        public ValueParameters(@Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> descriptors, boolean hasStableParameterNames) {
            if (descriptors == null) {
                ValueParameters.$$$reportNull$$$0(0);
            }
            this.receiverType = receiverType;
            this.descriptors = descriptors;
            this.hasStableParameterNames = hasStableParameterNames;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$ValueParameters", "<init>"));
        }
    }

    private static class TypeAndName {
        public final KotlinType type;
        public final Name name;

        public TypeAndName(KotlinType type, Name name2) {
            this.type = type;
            this.name = name2;
        }
    }

    private static class VarargCheckResult {
        public final KotlinType parameterType;
        public final boolean isVararg;

        public VarargCheckResult(KotlinType parameterType, boolean isVararg) {
            this.parameterType = parameterType;
            this.isVararg = isVararg;
        }
    }
}

