/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.StorageProviderRealmModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageUtil;

public class MigrateTo1_4_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.4.0");

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        if (realm.getAuthenticationFlowsStream().count() == 0L) {
            DefaultAuthenticationFlows.migrateFlows((RealmModel)realm);
            DefaultRequiredActions.addActions((RealmModel)realm);
        }
        ImpersonationConstants.setupImpersonationService((KeycloakSession)session, (RealmModel)realm);
        this.migrateLDAPMappers(session, realm);
        this.migrateUsers(session, realm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    private void migrateLDAPMappers(KeycloakSession session, RealmModel realm) {
        List<String> mandatoryInLdap = Arrays.asList("username", "username-cn", "first name", "last name");
        ((StorageProviderRealmModel)realm).getUserStorageProvidersStream().filter(providerModel -> Objects.equals(providerModel.getProviderId(), "ldap")).forEachOrdered(providerModel -> realm.getComponentsStream(providerModel.getId()).filter(mapper -> mandatoryInLdap.contains(mapper.getName())).forEach(mapper -> {
            mapper = new ComponentModel(mapper);
            mapper.getConfig().putSingle((Object)"is.mandatory.in.ldap", (Object)"true");
            realm.updateComponent(mapper);
        }));
    }

    private void migrateUsers(KeycloakSession session, RealmModel realm) {
        HashMap<String, String> searchAttributes = new HashMap<String, String>(1);
        searchAttributes.put("keycloak.session.realm.users.query.include_service_account", Boolean.FALSE.toString());
        UserStoragePrivateUtil.userLocalStorage(session).searchForUserStream(realm, searchAttributes).forEach(user -> {
            String email = KeycloakModelUtils.toLowerCaseSafe((String)user.getEmail());
            if (email != null && !email.equals(user.getEmail())) {
                user.setEmail(email);
                UserCache userCache = UserStorageUtil.userCache((KeycloakSession)session);
                if (userCache != null) {
                    userCache.evict(realm, user);
                }
            }
        });
    }
}

