/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompositeException
extends RuntimeException {
    public CompositeException(List<Throwable> causes) {
        super("Multiple exceptions caught:", CompositeException.getFirstOrFail(causes));
        for (int i = 1; i < causes.size(); ++i) {
            this.addSuppressed(causes.get(i));
        }
    }

    private static Throwable getFirstOrFail(List<Throwable> causes) {
        if (causes == null || causes.isEmpty()) {
            throw new IllegalArgumentException("Composite Exception must contains at least one cause");
        }
        return ParameterValidation.nonNull(causes.get(0), "cause");
    }

    private static Throwable getFirstOrFail(Throwable[] causes) {
        if (causes == null || causes.length == 0) {
            throw new IllegalArgumentException("Composite Exception must contains at least one cause");
        }
        return ParameterValidation.nonNull(causes[0], "cause");
    }

    public CompositeException(Throwable ... causes) {
        super("Multiple exceptions caught:", CompositeException.getFirstOrFail(causes));
        for (int i = 1; i < causes.length; ++i) {
            this.addSuppressed(causes[i]);
        }
    }

    public CompositeException(CompositeException other, Throwable toBeAppended) {
        Throwable[] suppressed;
        for (Throwable throwable : suppressed = other.getSuppressed()) {
            this.addSuppressed(throwable);
        }
        this.addSuppressed(toBeAppended);
        this.initCause(other.getCause());
    }

    @Override
    public String getMessage() {
        String messageFromSuper = super.getMessage();
        StringBuilder message = messageFromSuper != null ? new StringBuilder(messageFromSuper) : new StringBuilder();
        message.append("\n\t[Exception 0] ").append(this.getCause());
        Throwable[] suppressed = this.getSuppressed();
        for (int i = 0; i < suppressed.length; ++i) {
            Throwable cause = suppressed[i];
            message.append("\n\t[Exception ").append(i + 1).append("] ").append(cause);
        }
        return message.toString();
    }

    public List<Throwable> getCauses() {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        causes.add(this.getCause());
        causes.addAll(Arrays.asList(this.getSuppressed()));
        return causes;
    }
}

