/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.CacheHolder;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangesUtils;
import org.keycloak.models.sessions.infinispan.changes.JpaChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.SessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;

public abstract class PersistentSessionsChangelogBasedTransaction<K, V extends SessionEntity>
implements SessionsChangelogBasedTransaction<K, V>,
NonBlockingTransaction {
    private static final Logger LOG = Logger.getLogger(PersistentSessionsChangelogBasedTransaction.class);
    protected final KeycloakSession kcSession;
    protected final Map<K, SessionUpdatesList<V>> updates = new HashMap<K, SessionUpdatesList<V>>();
    protected final Map<K, SessionUpdatesList<V>> offlineUpdates = new HashMap<K, SessionUpdatesList<V>>();
    private final String cacheName;
    private final ArrayBlockingQueue<PersistentUpdate> batchingQueue;
    private final CacheHolder<K, V> cacheHolder;
    private final CacheHolder<K, V> offlineCacheHolder;

    public PersistentSessionsChangelogBasedTransaction(KeycloakSession session, String cacheName, ArrayBlockingQueue<PersistentUpdate> batchingQueue, CacheHolder<K, V> cacheHolder, CacheHolder<K, V> offlineCacheHolder) {
        this.kcSession = session;
        this.cacheName = cacheName;
        this.batchingQueue = batchingQueue;
        this.cacheHolder = cacheHolder;
        this.offlineCacheHolder = offlineCacheHolder;
    }

    public Cache<K, SessionEntityWrapper<V>> getCache(boolean offline) {
        return offline ? this.offlineCacheHolder.cache() : this.cacheHolder.cache();
    }

    protected SessionFunction<V> getLifespanMsLoader(boolean offline) {
        return offline ? this.offlineCacheHolder.lifespanFunction() : this.cacheHolder.lifespanFunction();
    }

    protected SessionFunction<V> getMaxIdleMsLoader(boolean offline) {
        return offline ? this.offlineCacheHolder.maxIdleFunction() : this.cacheHolder.maxIdleFunction();
    }

    protected Map<K, SessionUpdatesList<V>> getUpdates(boolean offline) {
        return offline ? this.offlineUpdates : this.updates;
    }

    public SessionEntityWrapper<V> get(K key, boolean offline) {
        SessionUpdatesList<Object> myUpdates = this.getUpdates(offline).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.getCache(offline).get(key);
            if (wrappedEntity == null) {
                return null;
            }
            ((SessionEntity)wrappedEntity.getEntity()).setOffline(offline);
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.getUpdates(offline).put(key, myUpdates);
            return wrappedEntity;
        }
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().map(SessionUpdateTask::getOperation).anyMatch(SessionUpdateTask.CacheOperation.REMOVE::equals);
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    @Override
    public void asyncCommit(AggregateCompletionStage<Void> stage, Consumer<DatabaseUpdate> databaseUpdates) {
        JpaChangesPerformer persister = null;
        for (Map.Entry entry : Stream.concat(this.updates.entrySet().stream(), this.offlineUpdates.entrySet().stream()).toList()) {
            CacheHolder<K, V> c;
            SessionUpdatesList sessionUpdates = (SessionUpdatesList)entry.getValue();
            if (sessionUpdates.getUpdateTasks().isEmpty()) continue;
            SessionEntityWrapper sessionWrapper = sessionUpdates.getEntityWrapper();
            Object entity = sessionWrapper.getEntity();
            boolean isOffline = ((SessionEntity)entity).isOffline();
            if (sessionUpdates.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT) continue;
            RealmModel realm = sessionUpdates.getRealm();
            long lifespanMs = this.getLifespanMsLoader(isOffline).apply(realm, sessionUpdates.getClient(), entity);
            long maxIdleTimeMs = this.getMaxIdleMsLoader(isOffline).apply(realm, sessionUpdates.getClient(), entity);
            MergedUpdate merged = MergedUpdate.computeUpdate(sessionUpdates.getUpdateTasks(), sessionWrapper, lifespanMs, maxIdleTimeMs);
            if (merged == null) continue;
            CacheHolder<K, V> cacheHolder = c = isOffline ? this.offlineCacheHolder : this.cacheHolder;
            if (c.cache() != null) {
                InfinispanChangesUtils.runOperationInCluster(c, entry.getKey(), merged, ((SessionUpdatesList)entry.getValue()).getEntityWrapper(), stage, LOG);
            }
            if (persister == null && !(persister = new JpaChangesPerformer(this.cacheName, this.batchingQueue)).isNonBlocking()) {
                databaseUpdates.accept(persister::write);
            }
            if (persister.isNonBlocking()) {
                persister.asyncWrite(stage, entry, merged);
                continue;
            }
            persister.registerChange(entry, merged);
        }
    }

    @Override
    public void asyncRollback(AggregateCompletionStage<Void> stage) {
        this.updates.clear();
        this.offlineUpdates.clear();
    }

    @Override
    public void addTask(K key, SessionUpdateTask<V> originalTask) {
        if (!(originalTask instanceof PersistentSessionUpdateTask)) {
            throw new IllegalArgumentException("Task must be instance of PersistentSessionUpdateTask");
        }
        PersistentSessionUpdateTask task = (PersistentSessionUpdateTask)originalTask;
        SessionUpdatesList<V> myUpdates = this.getUpdates(task.isOffline()).get(key);
        if (myUpdates != null) {
            myUpdates.addAndExecute(task);
            return;
        }
        this.lookupAndAndExecuteTask(key, task);
    }

    @Override
    public void restartEntity(K key, SessionUpdateTask<V> restartTask) {
        if (!(restartTask instanceof PersistentSessionUpdateTask)) {
            throw new IllegalArgumentException("Task must be instance of PersistentSessionUpdateTask");
        }
        PersistentSessionUpdateTask task = (PersistentSessionUpdateTask)restartTask;
        SessionUpdatesList<V> myUpdates = this.getUpdates(task.isOffline()).get(key);
        if (myUpdates != null) {
            myUpdates.getUpdateTasks().clear();
            myUpdates.addAndExecute(task);
            return;
        }
        this.lookupAndAndExecuteTask(key, task);
    }

    private void lookupAndAndExecuteTask(K key, PersistentSessionUpdateTask<V> task) {
        SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.getCache(task.isOffline()).get(key);
        if (wrappedEntity == null) {
            LOG.tracef("Not present cache item for key %s", key);
            return;
        }
        ((SessionEntity)wrappedEntity.getEntity()).setOffline(task.isOffline());
        RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
        SessionUpdatesList<V> myUpdates = new SessionUpdatesList<V>(realm, wrappedEntity);
        this.getUpdates(task.isOffline()).put(key, myUpdates);
        myUpdates.addAndExecute(task);
    }

    public void addTask(K key, SessionUpdateTask<V> task, V entity, UserSessionModel.SessionPersistenceState persistenceState) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)entity).getRealmId());
        SessionEntityWrapper<V> wrappedEntity = new SessionEntityWrapper<V>(entity);
        SessionUpdatesList<V> myUpdates = new SessionUpdatesList<V>(realm, wrappedEntity, persistenceState);
        this.getUpdates(((SessionEntity)entity).isOffline()).put(key, myUpdates);
        if (task != null) {
            myUpdates.addAndExecute(task);
        }
    }

    @Deprecated(forRemoval=true, since="26.4")
    public void reloadEntityInCurrentTransaction(RealmModel realm, K key, SessionEntityWrapper<V> entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        boolean offline = ((SessionEntity)entity.getEntity()).isOffline();
        SessionEntityWrapper latestEntity = (SessionEntityWrapper)this.getCache(offline).get(key);
        if (latestEntity == null) {
            return;
        }
        SessionUpdatesList newUpdates = new SessionUpdatesList(realm, latestEntity);
        SessionUpdatesList<V> existingUpdates = this.getUpdates(((SessionEntity)entity.getEntity()).isOffline()).get(key);
        if (existingUpdates != null) {
            newUpdates.setUpdateTasks(existingUpdates.getUpdateTasks());
        }
        this.getUpdates(((SessionEntity)entity.getEntity()).isOffline()).put(key, newUpdates);
    }

    public SessionEntityWrapper<V> importSession(RealmModel realmModel, K key, SessionEntityWrapper<V> session, boolean offline, long lifespan, long maxIdle) {
        Map updates = this.getUpdates(offline);
        SessionUpdatesList<V> updatesList = updates.get(key);
        if (updatesList != null) {
            return updatesList.getEntityWrapper();
        }
        SessionEntityWrapper existing = null;
        try {
            if (this.getCache(offline) != null) {
                existing = (SessionEntityWrapper)this.getCache(offline).putIfAbsent(key, session, lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
            }
        }
        catch (RuntimeException exception) {
            LOG.debugf((Throwable)exception, "Failed to import session %s", session);
        }
        if (existing == null) {
            updates.put(key, new SessionUpdatesList<V>(realmModel, session));
            return null;
        }
        updates.put(key, new SessionUpdatesList(realmModel, existing));
        return existing;
    }

    public void importSessionsConcurrently(RealmModel realmModel, Map<K, SessionEntityWrapper<V>> sessions, boolean offline) {
        Cache cache = this.getCache(offline);
        if (sessions.isEmpty() || cache == null) {
            return;
        }
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        ConcurrentHashMap<Object, SessionEntityWrapper> allSessions = new ConcurrentHashMap<Object, SessionEntityWrapper>();
        Map updates = this.getUpdates(offline);
        SessionFunction lifespanFunction = this.getLifespanMsLoader(offline);
        SessionFunction maxIdleFunction = this.getMaxIdleMsLoader(offline);
        sessions.forEach((key, session) -> {
            if (updates.containsKey(key)) {
                return;
            }
            ClientModel clientModel = session.getClientIfNeeded(realmModel);
            Object sessionEntity = session.getEntity();
            Long lifespan = lifespanFunction.apply(realmModel, clientModel, sessionEntity);
            Long maxIdle = maxIdleFunction.apply(realmModel, clientModel, sessionEntity);
            if (lifespan == -2L || maxIdle == -2L) {
                return;
            }
            CompletionStage future = cache.putIfAbsentAsync(key, session, lifespan.longValue(), TimeUnit.MILLISECONDS, maxIdle.longValue(), TimeUnit.MILLISECONDS).exceptionally(throwable -> {
                LOG.debugf(throwable, "Failed to import session %s", session);
                return null;
            });
            stage.dependsOn(((CompletableFuture)future).thenAccept(existing -> allSessions.put(key, existing == null ? session : existing)));
        });
        CompletionStages.join((CompletionStage)stage.freeze());
        allSessions.forEach((key, wrapper) -> updates.put(key, new SessionUpdatesList(realmModel, wrapper)));
    }
}

