/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.sort;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.protobufs.FieldSort;
import org.opensearch.protobufs.FieldSortMap;
import org.opensearch.protobufs.SortCombinations;
import org.opensearch.protobufs.SortOptions;
import org.opensearch.protobufs.SortOrder;
import org.opensearch.protobufs.SortOrderMap;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.ScoreSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.transport.grpc.proto.request.search.sort.FieldSortBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.GeoDistanceSortProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.ScoreSortProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.ScriptSortProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;
import org.opensearch.transport.grpc.util.ProtobufEnumUtils;

public class SortBuilderProtoUtils {
    public static final String SCORE_NAME = "_score";

    private SortBuilderProtoUtils() {
    }

    public static List<SortBuilder<?>> fromProto(List<SortCombinations> sortProto, QueryBuilderProtoConverterRegistry registry) {
        ArrayList sortFields = new ArrayList(sortProto.size());
        block7: for (SortCombinations sortCombination : sortProto) {
            SortBuilder<?> sortBuilder = null;
            switch (sortCombination.getSortCombinationsCase()) {
                case FIELD: {
                    String fieldName = sortCombination.getField();
                    sortBuilder = SortBuilderProtoUtils.fieldOrScoreSort(fieldName);
                    break;
                }
                case FIELD_WITH_DIRECTION: {
                    sortBuilder = SortBuilderProtoUtils.fromSortOrderMap(sortCombination.getFieldWithDirection());
                    break;
                }
                case FIELD_WITH_ORDER: {
                    sortBuilder = SortBuilderProtoUtils.fromFieldSortMap(sortCombination.getFieldWithOrder(), registry);
                    break;
                }
                case OPTIONS: {
                    sortBuilder = SortBuilderProtoUtils.fromSortOptions(sortCombination.getOptions(), registry);
                    break;
                }
                case SORTCOMBINATIONS_NOT_SET: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported sort combination case: " + String.valueOf(sortCombination.getSortCombinationsCase()));
                }
            }
            if (sortBuilder == null) continue;
            sortFields.add(sortBuilder);
        }
        return sortFields;
    }

    public static SortBuilder<?> fieldOrScoreSort(String fieldName) {
        if (SCORE_NAME.equals(fieldName)) {
            return new ScoreSortBuilder();
        }
        return new FieldSortBuilder(fieldName);
    }

    private static SortBuilder<?> fromSortOrderMap(SortOrderMap sortOrderMap) {
        if (sortOrderMap.getSortOrderMapMap().isEmpty() || sortOrderMap.getSortOrderMapMap().size() > 1) {
            throw new IllegalArgumentException("SortOrderMap cannot be empty or contain multiple entries");
        }
        String fieldName = (String)sortOrderMap.getSortOrderMapMap().keySet().iterator().next();
        SortOrder direction = (SortOrder)sortOrderMap.getSortOrderMapMap().get(fieldName);
        org.opensearch.search.sort.SortOrder order = SortBuilderProtoUtils.parseSortOrder(direction);
        SortBuilder sortBuilder = SortBuilderProtoUtils.fieldOrScoreSort(fieldName).order(order);
        return sortBuilder;
    }

    private static SortBuilder<?> fromFieldSortMap(FieldSortMap fieldSortMap, QueryBuilderProtoConverterRegistry registry) {
        if (fieldSortMap.getFieldSortMapMap().isEmpty() || fieldSortMap.getFieldSortMapMap().size() > 1) {
            throw new IllegalArgumentException("FieldSortMap cannot be empty or contain multiple entries");
        }
        String fieldName = (String)fieldSortMap.getFieldSortMapMap().keySet().iterator().next();
        FieldSort fieldSort = (FieldSort)fieldSortMap.getFieldSortMapMap().get(fieldName);
        return FieldSortBuilderProtoUtils.fromProto(fieldName, fieldSort, registry);
    }

    private static SortBuilder<?> fromSortOptions(SortOptions sortOptions, QueryBuilderProtoConverterRegistry registry) {
        if (sortOptions.hasXScore()) {
            return ScoreSortProtoUtils.fromProto(sortOptions.getXScore());
        }
        if (sortOptions.hasXGeoDistance()) {
            return GeoDistanceSortProtoUtils.fromProto(sortOptions.getXGeoDistance(), registry);
        }
        if (sortOptions.hasXScript()) {
            return ScriptSortProtoUtils.fromProto(sortOptions.getXScript(), registry);
        }
        throw new IllegalArgumentException("Unknown sort options type");
    }

    private static org.opensearch.search.sort.SortOrder parseSortOrder(SortOrder protobufOrder) {
        String orderString = ProtobufEnumUtils.convertToString(protobufOrder);
        return org.opensearch.search.sort.SortOrder.fromString((String)orderString);
    }
}

