/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGenSendBuiltins;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGenThrowBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGenThrowBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGen;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenASend;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenAThrow;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PAsyncGenAThrow})
public final class AsyncGenThrowBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = AsyncGenThrowBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AsyncGenThrowBuiltinsFactory.getFactories();
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Close
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static Object close(PAsyncGenAThrow self) {
            self.setState(PAsyncGenASend.AwaitableState.CLOSED);
            return PNone.NONE;
        }
    }

    @Builtin(name="throw", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Throw
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PAsyncGenAThrow var2, Object var3, Object var4, Object var5);

        @NeverDefault
        public static Throw create() {
            return AsyncGenThrowBuiltinsFactory.ThrowFactory.create(null);
        }

        @Specialization
        public Object doThrow(VirtualFrame frame, PAsyncGenAThrow self, Object arg1, Object arg2, Object arg3, @Bind Node inliningTarget, @Cached PRaiseNode raiseReuse, @Cached CommonGeneratorBuiltins.ThrowNode throwNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopAsyncIteration, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isGeneratorExit, @Cached BuiltinClassProfiles.IsBuiltinObjectExactProfile isAGWrappedValue) {
            Object retval;
            if (self.getState() == PAsyncGenASend.AwaitableState.CLOSED) {
                throw raiseReuse.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_ATHROW);
            }
            try {
                retval = throwNode.execute(frame, self.receiver, arg1, arg2, arg3);
            }
            catch (PException e) {
                if (self.arg1 != null) {
                    throw AsyncGenSendBuiltins.handleAGError(self.receiver, e, inliningTarget, isStopAsyncIteration, isGeneratorExit);
                }
                if (isStopAsyncIteration.profileException(inliningTarget, e, PythonBuiltinClassType.StopAsyncIteration) || isGeneratorExit.profileException(inliningTarget, e, PythonBuiltinClassType.GeneratorExit)) {
                    throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.StopIteration);
                }
                throw e;
            }
            if (self.arg1 != null) {
                return AsyncGenSendBuiltins.unwrapAGYield(self.receiver, retval, inliningTarget, isAGWrappedValue);
            }
            if (isAGWrappedValue.profileObject(inliningTarget, retval, PythonBuiltinClassType.PAsyncGenAWrappedValue)) {
                throw Send.yieldClose(inliningTarget, self, self.receiver);
            }
            return retval;
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class Send
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object send(VirtualFrame frame, PAsyncGenAThrow self, Object sent, @Bind Node inliningTarget, @Cached PRaiseNode raiseReuse, @Cached PRaiseNode raiseAlreadyRunning, @Cached PRaiseNode raiseStopAsyncIteraion, @Cached PRaiseNode raiseNonNodeToNewCoro, @Cached CommonGeneratorBuiltins.ThrowNode throwNode, @Cached BuiltinClassProfiles.IsBuiltinObjectExactProfile isAGWrappedValue, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopAsyncIter, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isGeneratorExit, @Cached PRaiseNode raiseStopIteration, @Cached CommonGeneratorBuiltins.SendNode sendNode) {
            Object retval;
            PAsyncGen gen = self.receiver;
            if (self.getState() == PAsyncGenASend.AwaitableState.CLOSED) {
                throw raiseReuse.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_ATHROW);
            }
            if (self.receiver.isFinished()) {
                self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                throw raiseStopIteration.raise(inliningTarget, PythonBuiltinClassType.StopIteration);
            }
            if (self.getState() == PAsyncGenASend.AwaitableState.INIT) {
                if (gen.isRunningAsync()) {
                    self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                    throw raiseAlreadyRunning.raise(inliningTarget, PythonBuiltinClassType.RuntimeError);
                }
                if (gen.isClosed()) {
                    self.setState(PAsyncGenASend.AwaitableState.CLOSED);
                    throw raiseStopAsyncIteraion.raise(inliningTarget, PythonBuiltinClassType.StopAsyncIteration);
                }
                if (sent != PNone.NONE) {
                    throw raiseNonNodeToNewCoro.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.SEND_NON_NONE_TO_UNSTARTED_GENERATOR);
                }
                self.setState(PAsyncGenASend.AwaitableState.ITER);
                gen.setRunningAsync(true);
                if (self.arg1 == null) {
                    gen.markClosed();
                    try {
                        retval = throwNode.execute(frame, gen, (Object)PythonBuiltinClassType.GeneratorExit, PNone.NO_VALUE, PNone.NO_VALUE);
                    }
                    catch (PException e) {
                        throw Send.checkError(self, gen, e, inliningTarget, isStopAsyncIter, isGeneratorExit);
                    }
                    if (isAGWrappedValue.profileObject(inliningTarget, retval, PythonBuiltinClassType.PAsyncGenAWrappedValue)) {
                        throw Send.yieldClose(inliningTarget, self, gen);
                    }
                } else {
                    Object retval2;
                    try {
                        retval2 = throwNode.execute(frame, gen, self.arg1, self.arg2, self.arg3);
                    }
                    catch (PException e) {
                        PException exception = AsyncGenSendBuiltins.handleAGError(gen, e, inliningTarget, isStopAsyncIter, isGeneratorExit);
                        throw Send.checkError(self, gen, exception, inliningTarget, isStopAsyncIter, isGeneratorExit);
                    }
                    return AsyncGenSendBuiltins.unwrapAGYield(gen, retval2, inliningTarget, isAGWrappedValue);
                }
            }
            try {
                retval = sendNode.execute(frame, gen, sent);
            }
            catch (PException e) {
                if (self.arg1 != null) {
                    throw AsyncGenSendBuiltins.handleAGError(gen, e, inliningTarget, isStopAsyncIter, isGeneratorExit);
                }
                throw Send.checkError(self, gen, e, inliningTarget, isStopAsyncIter, isGeneratorExit);
            }
            if (self.arg1 != null) {
                return AsyncGenSendBuiltins.unwrapAGYield(gen, retval, inliningTarget, isAGWrappedValue);
            }
            if (isAGWrappedValue.profileObject(inliningTarget, retval, PythonBuiltinClassType.PAsyncGenAWrappedValue)) {
                throw Send.yieldClose(inliningTarget, self, gen);
            }
            return retval;
        }

        static PException yieldClose(Node inliningTarget, PAsyncGenAThrow athrow, PAsyncGen gen) {
            gen.setRunningAsync(false);
            athrow.setState(PAsyncGenASend.AwaitableState.CLOSED);
            return PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.GENERATOR_IGNORED_EXIT);
        }

        static PException checkError(PAsyncGenAThrow athrow, PAsyncGen gen, PException exception, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile isStopAsyncIter, BuiltinClassProfiles.IsBuiltinObjectProfile isGenExit) {
            gen.setRunningAsync(false);
            athrow.setState(PAsyncGenASend.AwaitableState.CLOSED);
            if (athrow.arg1 == null && (isStopAsyncIter.profileException(inliningTarget, exception, PythonBuiltinClassType.StopAsyncIteration) || isGenExit.profileException(inliningTarget, exception, PythonBuiltinClassType.GeneratorExit))) {
                return PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.StopIteration);
            }
            return exception;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class Next
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        public Object doSend(VirtualFrame frame, PAsyncGenAThrow self, @Cached Send send) {
            return send.execute(frame, self, PNone.NONE);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class Iter
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doIter(PAsyncGenAThrow self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.am_await, isComplex=true)
    @GenerateNodeFactory
    public static abstract class Await
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doAwait(PAsyncGenAThrow self) {
            return self;
        }
    }
}

