/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalInstantPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToFractionalSecondDigitsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalInstantNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;

public class TemporalInstantPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalInstantPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalInstantPrototypeBuiltins();

    protected TemporalInstantPrototypeBuiltins() {
        super(JSTemporalInstant.PROTOTYPE_NAME, TemporalInstantPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalInstantPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantGetterNodeGen.create(context, builtin, builtinEnum, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantAddSubNodeGen.create(context, builtin, 1, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantAddSubNodeGen.create(context, builtin, -1, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantUntilSinceNodeGen.create(context, builtin, 1, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantUntilSinceNodeGen.create(context, builtin, -1, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 6: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantRoundNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 7: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantEqualsNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToStringNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: 
            case 10: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToLocaleStringNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 11: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 12: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToZonedDateTimeISONodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalInstantPrototype implements BuiltinEnum<TemporalInstantPrototype>
    {
        epochMilliseconds(0),
        epochNanoseconds(0),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toZonedDateTimeISO(1);

        private final int length;

        private TemporalInstantPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(epochMilliseconds, epochNanoseconds).contains(this);
        }
    }

    public static abstract class JSTemporalInstantGetterNode
    extends JSBuiltinNode {
        protected final TemporalInstantPrototype property;

        protected JSTemporalInstantGetterNode(JSContext context, JSBuiltin builtin, TemporalInstantPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object instantGetter(JSTemporalInstantObject instant) {
            BigInt ns = instant.getNanoseconds();
            switch (this.property.ordinal()) {
                case 0: {
                    return TemporalUtil.nanosToMillis(ns);
                }
                case 1: {
                    return instant.getNanoseconds();
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalInstantAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalInstantObject addDurationToOrSubtractDurationFromInstant(JSTemporalInstantObject instant, Object temporalDurationLike, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            if (duration.getDays() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0 || duration.getYears() != 0.0) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("Temporal.Instant does not support adding or subtracting a Duration with non-zero days, months, weeks, or years.");
            }
            BigInt ns = TemporalUtil.addInstant(instant.getNanoseconds(), (double)this.sign * duration.getHours(), (double)this.sign * duration.getMinutes(), (double)this.sign * duration.getSeconds(), (double)this.sign * duration.getMilliseconds(), (double)this.sign * duration.getMicroseconds(), (double)this.sign * duration.getNanoseconds());
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), ns);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalInstantUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalInstant(JSTemporalInstantObject instant, Object otherObj, Object options, @Cached ToTemporalInstantNode toTemporalInstantNode, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalInstantObject other = toTemporalInstantNode.execute(otherObj);
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingTimeOrAuto, TemporalUtil.unitMappingTime, TemporalUtil.Unit.NANOSECOND, TemporalUtil.Unit.SECOND);
            TemporalUtil.NormalizedTimeDurationWithTotalRecord diffRecord = TemporalUtil.differenceInstant(instant.getNanoseconds(), other.getNanoseconds(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
            BigInt norm = diffRecord.normalizedTimeDuration();
            TimeDurationRecord result = TemporalUtil.balanceTimeDuration(norm, settings.largestUnit());
            JSRealm realm = this.getRealm();
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, (double)this.sign * result.hours(), (double)this.sign * result.minutes(), (double)this.sign * result.seconds(), (double)this.sign * result.milliseconds(), (double)this.sign * result.microseconds(), (double)this.sign * result.nanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalInstantObject round(JSTemporalInstantObject instant, Object roundToParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            long maximum;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, roundToParam);
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            int roundingIncrement = getRoundingIncrementOption.execute((Object)roundTo);
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(roundTo, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.REQUIRED);
            if (TemporalUtil.Unit.HOUR == smallestUnit) {
                maximum = 24L;
            } else if (TemporalUtil.Unit.MINUTE == smallestUnit) {
                maximum = 1440L;
            } else if (TemporalUtil.Unit.SECOND == smallestUnit) {
                maximum = 86400L;
            } else if (TemporalUtil.Unit.MILLISECOND == smallestUnit) {
                maximum = 86400000L;
            } else if (TemporalUtil.Unit.MICROSECOND == smallestUnit) {
                maximum = 500654080L;
            } else {
                assert (TemporalUtil.Unit.NANOSECOND == smallestUnit);
                maximum = 86400000000000L;
            }
            TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum, true, this, errorBranch);
            BigInt roundedNs = TemporalUtil.roundTemporalInstant(instant.getNanoseconds(), roundingIncrement, smallestUnit, roundingMode);
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), roundedNs);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalInstantObject instant, Object otherObj, @Cached ToTemporalInstantNode toTemporalInstantNode) {
            JSTemporalInstantObject other = toTemporalInstantNode.execute(otherObj);
            return instant.getNanoseconds().compareTo(other.getNanoseconds()) == 0;
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    @ImportStatic(value={TemporalConstants.class})
    public static abstract class JSTemporalInstantToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalInstantObject instant, Object optionsParam, @Cached ToFractionalSecondDigitsNode toFractionalSecondDigits, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached(value="create(TIME_ZONE, getContext())") PropertyGetNode getTimeZone, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            int digits = toFractionalSecondDigits.execute((Object)options);
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(options, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.HOUR) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
            }
            Object timeZone = getTimeZone.getValue((Object)options);
            if (timeZone != Undefined.instance) {
                timeZone = toTimeZoneIdentifier.execute(timeZone);
            }
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecisionRecord(smallestUnit, digits);
            BigInt roundedNs = TemporalUtil.roundTemporalInstant(instant.getNanoseconds(), precision.getIncrement(), precision.getUnit(), roundingMode);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject roundedInstant = JSTemporalInstant.create(this.getContext(), realm, roundedNs);
            return TemporalUtil.temporalInstantToString(roundedInstant, timeZone, precision.getPrecision());
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalInstantObject instant) {
            return TemporalUtil.temporalInstantToString(instant, (Object)Undefined.instance, TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToZonedDateTimeISONode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToZonedDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject toZonedDateTimeISO(JSTemporalInstantObject instant, Object timeZoneParam, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier) {
            TruffleString timeZone = toTimeZoneIdentifier.execute(timeZoneParam);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), instant.getNanoseconds(), timeZone, TemporalConstants.ISO8601);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }
}

