/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalInstantObject
extends JSNonProxyObject {
    private final BigInt nanoseconds;

    protected JSTemporalInstantObject(Shape shape, JSDynamicObject proto, BigInt nanoseconds) {
        super(shape, proto);
        assert (TemporalUtil.isValidEpochNanoseconds(nanoseconds));
        this.nanoseconds = nanoseconds;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Instant asInstant() {
        BigInt[] res = this.nanoseconds.divideAndRemainder(TemporalUtil.BI_NS_PER_SECOND);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage
    boolean isTimeZone() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone() {
        return ZoneId.of("UTC");
    }

    @ExportMessage
    boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() {
        return LocalDate.ofInstant(this.asInstant(), this.asTimeZone());
    }

    @ExportMessage
    boolean isTime() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() {
        return LocalTime.ofInstant(this.asInstant(), this.asTimeZone());
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalInstant.TO_STRING_TAG;
    }
}

