/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public final class PTeeDataObject
extends PythonBuiltinObject {
    private Object it;
    private Object[] values;
    private int numread;
    private boolean running;
    private PTeeDataObject nextlink;

    public PTeeDataObject(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public PTeeDataObject(Object it, Object cls, Shape instanceShape) {
        super(cls, instanceShape);
        this.it = it;
        this.values = new Object[128];
        this.numread = 0;
        this.running = false;
        this.nextlink = null;
    }

    public Object getIt() {
        return this.it;
    }

    public void setIt(Object it) {
        this.it = it;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public int getNumread() {
        return this.numread;
    }

    public void setNumread(int numread) {
        this.numread = numread;
    }

    public boolean getRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public PTeeDataObject getNextlink() {
        return this.nextlink;
    }

    public void setNextlink(PTeeDataObject nextlink) {
        this.nextlink = nextlink;
    }

    PTeeDataObject jumplink(PythonLanguage language) {
        if (this.getNextlink() == null) {
            PTeeDataObject dataObj;
            this.nextlink = dataObj = PFactory.createTeeDataObject(language, this.getIt());
        }
        return this.nextlink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getItem(VirtualFrame frame, Node inliningTarget, int i, PyIterNextNode nextNode, PRaiseNode raiseNode) {
        assert (i < 128);
        if (i < this.numread) {
            return this.values[i];
        }
        assert (i == this.numread);
        if (this.running) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REENTER_TEE_ITERATOR);
        }
        this.running = true;
        try {
            Object value = nextNode.execute((Frame)frame, inliningTarget, this.it);
            this.values[this.numread++] = value;
            Object object = value;
            return object;
        }
        finally {
            this.running = false;
        }
    }
}

