﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/ComputationModelState.h>
#include <aws/iotsitewise/model/ErrorDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {

/**
 * <p>Contains current status information for a computation model.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ComputationModelStatus">AWS
 * API Reference</a></p>
 */
class ComputationModelStatus {
 public:
  AWS_IOTSITEWISE_API ComputationModelStatus() = default;
  AWS_IOTSITEWISE_API ComputationModelStatus(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API ComputationModelStatus& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The current state of the computation model.</p>
   */
  inline ComputationModelState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(ComputationModelState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline ComputationModelStatus& WithState(ComputationModelState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{

  inline const ErrorDetails& GetError() const { return m_error; }
  inline bool ErrorHasBeenSet() const { return m_errorHasBeenSet; }
  template <typename ErrorT = ErrorDetails>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = ErrorDetails>
  ComputationModelStatus& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}
 private:
  ComputationModelState m_state{ComputationModelState::NOT_SET};
  bool m_stateHasBeenSet = false;

  ErrorDetails m_error;
  bool m_errorHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
