/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database.load;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadService;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeChildrenLoading;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.ArrayUtils;

public class TreeLoadVisualizer
implements ILoadVisualizer<Object[]> {
    public static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private final DBNNode parent;
    private final TreeNodeSpecial placeHolder;
    private final AbstractTreeViewer viewer;

    public TreeLoadVisualizer(AbstractTreeViewer viewer, TreeNodeSpecial placeHolder, DBNNode parent) {
        this.viewer = viewer;
        this.placeHolder = placeHolder;
        this.parent = parent;
    }

    public DBRProgressMonitor overwriteMonitor(DBRProgressMonitor monitor) {
        return monitor;
    }

    public boolean isCompleted() {
        return this.placeHolder.isDisposed() || this.viewer.testFindItem((Object)this.parent) == null;
    }

    public void visualizeLoading() {
        this.viewer.refresh((Object)this.placeHolder, true);
    }

    public void completeLoading(Object[] children) {
        Control viewerControl = this.viewer.getControl();
        if (viewerControl.isDisposed()) {
            return;
        }
        try {
            TreeItem item;
            viewerControl.setRedraw(false);
            if (children == null) {
                this.viewer.collapseToLevel((Object)this.parent, -1);
            }
            if (!((item = (TreeItem)this.viewer.testFindItem((Object)this.placeHolder)) == null || item.isDisposed() || item.getParentItem() != null && item.getParentItem().isDisposed() && !(this.parent instanceof IWorkspaceRoot))) {
                this.viewer.remove((Object)this.placeHolder);
            }
            if (!ArrayUtils.isEmpty((Object[])children)) {
                boolean isEmpty = false;
                if (viewerControl instanceof Tree) {
                    isEmpty = ((Tree)viewerControl).getItemCount() == 0;
                } else if (viewerControl instanceof Table) {
                    boolean bl = isEmpty = ((Table)viewerControl).getItemCount() == 0;
                }
                if (isEmpty) {
                    this.viewer.setInput(this.viewer.getInput());
                } else {
                    this.viewer.refresh((Object)this.parent);
                }
            }
        }
        finally {
            this.placeHolder.dispose(this.parent);
            if (!viewerControl.isDisposed()) {
                viewerControl.setRedraw(true);
            }
        }
    }

    public static Object[] expandChildren(AbstractTreeViewer viewer, TreeLoadService service) {
        DBNNode parent = service.getParentNode();
        TreeNodeChildrenLoading placeHolder = TreeNodeChildrenLoading.createLoadingPlaceHolder(parent);
        if (TreeNodeChildrenLoading.canBeginLoading(parent)) {
            TreeLoadVisualizer visualizer = new TreeLoadVisualizer(viewer, placeHolder, parent);
            LoadingJob.createService((ILoadService)service, (ILoadVisualizer)visualizer).schedule();
            return new Object[]{placeHolder};
        }
        return EMPTY_ELEMENT_ARRAY;
    }
}

