gap> K := SymmetricGroup(15);;
gap> H := SymmetricGroup(7);;
gap> G := WreathProduct(K, H);;
gap> iso := IsomorphismWreathProduct(G);;

# Overflow in Print, but not Display
gap> g := (1,38,47,95,76,29,11,33,60,92,83,21,4,40,53,97,82,28,6,31,57,101,84,17)(2,36,48,102,79,27,3,39,51,103,90,19,13,43,54,99,78,24,8,37,58,96,86,20,5,32,46,93,80,18,15,44,52,100,87,23,7,42,56,105,85,16,12,41,49,104,77,30,9,45,50,98,89,22)(10,34,59,91,88,26,14,35,55,94,81,25)(61,64,69,67,68,71,74,73,72,62,75,66)(65,70);;
gap> w := g ^ iso;;
gap> Print(w, "\n");
[ (1,8,7,12,11,3,9,15,14,5,2,6)(4,10), (1,12,3,15,9,8,7,2)(4,13,6)(11,14), (1,\
12,11,4,14,7,13,9,6,3,15,5,10,8,2), (1,3,12,11,15,2,5,8,7,10,4,14)(6,13), (1,4\
,9,7,8,11,14,13,12,2,15,6)(5,10), (1,14,7,13,11,5,3,9,2,15,4,12,8,6,10), (1,13\
,15,10,12,4,6,11,9,3,5)(2,8,14), (1,3,4,7,6,2) ]
gap> Display(w);
                   1                                   2                  
( (1,8,7,12,11,3,9,15,14,5,2,6)(4,10), (1,12,3,15,9,8,7,2)(4,13,6)(11,14),

                    3                                     4                   
  (1,12,11,4,14,7,13,9,6,3,15,5,10,8,2), (1,3,12,11,15,2,5,8,7,10,4,14)(6,13),

                   5                                      6                   
  (1,4,9,7,8,11,14,13,12,2,15,6)(5,10), (1,14,7,13,11,5,3,9,2,15,4,12,8,6,10),

                   7                         top     
  (1,13,15,10,12,4,6,11,9,3,5)(2,8,14); (1,3,4,7,6,2) )

# Overflow in a middle component
gap> K := SymmetricGroup(50);;
gap> H := SymmetricGroup(7);;
gap> G := WreathProduct(K, H);;
gap> iso := IsomorphismWreathProduct(G);;
gap> g := (51,52,53,54)(101,146,116,111,131,129,105,127,149,119,134,123,135,145,124,125,143,115,121,106,107,110,112,139,138,126,141,132,103,128,104,144)(102,118,109,133,140,148,117,122,130,120,113,108)(136,150)(153,157,156,155,158,154);;
gap> w := g ^ iso;;
gap> Print(w, "\n");
[ (), (1,2,3,4), (1,46,16,11,31,29,5,27,49,19,34,23,35,45,24,25,43,15,21,6,7,1\
0,12,39,38,26,41,32,3,28,4,44)(2,18,9,33,40,48,17,22,30,20,13,8)(36,50), (3,7,\
6,5,8,4), (), (), (), () ]
gap> Display(w);
  1       2     
( (), (1,2,3,4),

                                       3
  (1,46,16,11,31,29,5,27,49,19,34,23,35,45,24,25,43,15,21,6,7,10,12,39,38,26\
  ,41,32,3,28,4,44)(2,18,9,33,40,48,17,22,30,20,13,8)(36,50),

        4        5   6   7   top
  (3,7,6,5,8,4), (), (), (); () )
gap> Display(w, rec(labels := false));
( (), (1,2,3,4),
  (1,46,16,11,31,29,5,27,49,19,34,23,35,45,24,25,43,15,21,6,7,10,12,39,38,26\
  ,41,32,3,28,4,44)(2,18,9,33,40,48,17,22,30,20,13,8)(36,50),
  (3,7,6,5,8,4), (), (), (); () )
gap> Display(w, rec(horizontal := false));
  1: ()
  2: (1,2,3,4)
  3: (1,46,16,11,31,29,5,27,49,19,34,23,35,45,24,25,43,15,21,6,7,10,12,39,38\
     ,26,41,32,3,28,4,44)(2,18,9,33,40,48,17,22,30,20,13,8)(36,50)
  4: (3,7,6,5,8,4)
  5: ()
  6: ()
  7: ()
top: ()
gap> Display(w, rec(horizontal := false, labels := false));
()
(1,2,3,4)
(1,46,16,11,31,29,5,27,49,19,34,23,35,45,24,25,43,15,21,6,7,10,12,39,38,26\
  ,41,32,3,28,4,44)(2,18,9,33,40,48,17,22,30,20,13,8)(36,50)
(3,7,6,5,8,4)
()
()
()
()

# Overflow in first component
gap> K := SymmetricGroup(50);;
gap> H := SymmetricGroup(7);;
gap> G := WreathProduct(K, H);;
gap> iso := IsomorphismWreathProduct(G);;
gap> g := (1,10,30,34,40,44,16,42,37,14,8)(2,28,3,20,36,15,39,33,31,4,18,41,46)(5,25,50,32,7,6,48,47,49,38,43,11,26,21,13,12)(9,17,24,29,23,22,19,27,35)(51,52,53,54,55,56,57);;
gap> w := g ^ iso;;
gap> Print(w, "\n");
[ (1,10,30,34,40,44,16,42,37,14,8)(2,28,3,20,36,15,39,33,31,4,18,41,46)(5,25,5\
0,32,7,6,48,47,49,38,43,11,26,21,13,12)(9,17,24,29,23,22,19,27,35), (1,2,3,4,5\
,6,7), (), (), (), (), (), () ]
gap> Display(w);
                                       1
( (1,10,30,34,40,44,16,42,37,14,8)(2,28,3,20,36,15,39,33,31,4,18,41,46)(5,25\
  ,50,32,7,6,48,47,49,38,43,11,26,21,13,12)(9,17,24,29,23,22,19,27,35),

         2         3   4   5   6   7   top
  (1,2,3,4,5,6,7), (), (), (), (), (); () )
gap> Display(w, rec(labels := false));
( (1,10,30,34,40,44,16,42,37,14,8)(2,28,3,20,36,15,39,33,31,4,18,41,46)(5,25\
  ,50,32,7,6,48,47,49,38,43,11,26,21,13,12)(9,17,24,29,23,22,19,27,35),
  (1,2,3,4,5,6,7), (), (), (), (), (); () )
gap> Display(w, rec(horizontal := false));
  1: (1,10,30,34,40,44,16,42,37,14,8)(2,28,3,20,36,15,39,33,31,4,18,41,46)(5\
     ,25,50,32,7,6,48,47,49,38,43,11,26,21,13,12)(9,17,24,29,23,22,19,27,35)
  2: (1,2,3,4,5,6,7)
  3: ()
  4: ()
  5: ()
  6: ()
  7: ()
top: ()
gap> Display(w, rec(horizontal := false, labels := false));
(1,10,30,34,40,44,16,42,37,14,8)(2,28,3,20,36,15,39,33,31,4,18,41,46)(5,25\
  ,50,32,7,6,48,47,49,38,43,11,26,21,13,12)(9,17,24,29,23,22,19,27,35)
(1,2,3,4,5,6,7)
()
()
()
()
()
()

# Overflow in last component
gap> K := SymmetricGroup(7);;
gap> H := SymmetricGroup(50);;
gap> G := WreathProduct(K, H);;
gap> iso := IsomorphismWreathProduct(G);;
gap> g := (  1,252, 14, 21,  7,249, 11, 18,  4,247,  9, 16,  2,250, 12, 19,  5,251, 13, 20,  6,246,  8, 15)(  3,248, 10, 17)( 22,267,127, 71,211,323,288,274,190,253, 92, 36,204,151,102,228,263,333,144,305,158,186, 313,222, 89,173,285,110,124,164,136, 80, 59, 52,339, 31,318,234, 24,269,129, 73,213,325,290,276,192,255,  94, 38,206,148, 99,225,260,330,141,302,155,183,309,218, 85,169,281,106,120,162,134, 78, 57, 50,337, 29, 316,232)( 23,268,128, 72,212,324,289,275,191,254, 93, 37,205,154,105,231,266,336,147,308,161,189,310,219,  86,170,282,107,121,168,140, 84, 63, 56,343, 35,322,238, 28,273,133, 77,217,329,294,280,196,259, 98, 42, 210,153,104,230,265,335,146,307,160,188,314,223, 90,174,286,111,125,165,137, 81, 60, 53,340, 32,319,235,  25,270,130, 74,214,326,291,277,193,256, 95, 39,207,150,101,227,262,332,143,304,157,185,311,220, 87,171, 283,108,122,163,135, 79, 58, 51,338, 30,317,233)( 26,271,131, 75,215,327,292,278,194,257, 96, 40,208,152, 103,229,264,334,145,306,159,187,312,221, 88,172,284,109,123,167,139, 83, 62, 55,342, 34,321,237, 27,272, 132, 76,216,328,293,279,195,258, 97, 41,209,149,100,226,261,331,142,303,156,184,315,224, 91,175,287,112, 126,166,138, 82, 61, 54,341, 33,320,236)( 43, 67,301,350,119,203,182,245, 49, 64,299,348,117,201,180,243,  47, 65,296,345,114,198,177,240, 44, 70,298,347,116,200,179,242, 46, 69,300,349,118,202,181,244, 48, 66, 297,346,115,199,178,241, 45, 68,295,344,113,197,176,239);;
gap> w := g ^ iso;;
gap> Print(w, "\n");
[ (1,7,4,2,5,6), (), (), (), (), (), (1,4,6,3,5,2,7), (), (), (1,5)(4,7), (), \
(), (), (), (), (), (), (2,7,5,3)(4,6), (), (), (), (), (), (), (), (), (2,7)(\
4,5), (), (), (1,4,3)(2,7,6), (), (), (), (), (), (), (), (), (), (), (), (), \
(), (), (), (), (), (), (), (), (1,36,2,3)(4,39,19,11,31,47,42,40,28,37,14,6,3\
0,22,15,33,38,48,21,44,23,27,45,32,13,25,41,16,18,24,20,12,9,8,49,5,46,34)(7,1\
0,43,50,17,29,26,35) ]
gap> Display(w);
        1        2   3   4   5   6          7         8   9       10      11 
( (1,7,4,2,5,6), (), (), (), (), (), (1,4,6,3,5,2,7), (), (), (1,5)(4,7), (),

  12  13  14  15  16  17        18        19  20  21  22  23  24  25  26 
  (), (), (), (), (), (), (2,7,5,3)(4,6), (), (), (), (), (), (), (), (),

      27      28  29        30        31  32  33  34  35  36  37  38  39  40 
  (2,7)(4,5), (), (), (1,4,3)(2,7,6), (), (), (), (), (), (), (), (), (), (),

  41  42  43  44  45  46  47  48  49  50 
  (), (), (), (), (), (), (), (), (), ();

                                      top
  (1,36,2,3)(4,39,19,11,31,47,42,40,28,37,14,6,30,22,15,33,38,48,21,44,23,27\
  ,45,32,13,25,41,16,18,24,20,12,9,8,49,5,46,34)(7,10,43,50,17,29,26,35)
  
   )
gap> Display(w, rec(labels := false));
( (1,7,4,2,5,6), (), (), (), (), (), (1,4,6,3,5,2,7), (), (), (1,5)(4,7), (),
  (), (), (), (), (), (), (2,7,5,3)(4,6), (), (), (), (), (), (), (), (),
  (2,7)(4,5), (), (), (1,4,3)(2,7,6), (), (), (), (), (), (), (), (), (), (),
  (), (), (), (), (), (), (), (), (), ();
  (1,36,2,3)(4,39,19,11,31,47,42,40,28,37,14,6,30,22,15,33,38,48,21,44,23,27\
  ,45,32,13,25,41,16,18,24,20,12,9,8,49,5,46,34)(7,10,43,50,17,29,26,35)
   )
gap> Display(w, rec(horizontal := false));
  1: (1,7,4,2,5,6)
  2: ()
  3: ()
  4: ()
  5: ()
  6: ()
  7: (1,4,6,3,5,2,7)
  8: ()
  9: ()
 10: (1,5)(4,7)
 11: ()
 12: ()
 13: ()
 14: ()
 15: ()
 16: ()
 17: ()
 18: (2,7,5,3)(4,6)
 19: ()
 20: ()
 21: ()
 22: ()
 23: ()
 24: ()
 25: ()
 26: ()
 27: (2,7)(4,5)
 28: ()
 29: ()
 30: (1,4,3)(2,7,6)
 31: ()
 32: ()
 33: ()
 34: ()
 35: ()
 36: ()
 37: ()
 38: ()
 39: ()
 40: ()
 41: ()
 42: ()
 43: ()
 44: ()
 45: ()
 46: ()
 47: ()
 48: ()
 49: ()
 50: ()
top: (1,36,2,3)(4,39,19,11,31,47,42,40,28,37,14,6,30,22,15,33,38,48,21,44,23\
     ,27,45,32,13,25,41,16,18,24,20,12,9,8,49,5,46,34)(7,10,43,50,17,29,26,3\
     5)
gap> Display(w, rec(horizontal := false, labels := false));
(1,7,4,2,5,6)
()
()
()
()
()
(1,4,6,3,5,2,7)
()
()
(1,5)(4,7)
()
()
()
()
()
()
()
(2,7,5,3)(4,6)
()
()
()
()
()
()
()
()
(2,7)(4,5)
()
()
(1,4,3)(2,7,6)
()
()
()
()
()
()
()
()
()
()
()
()
()
()
()
()
()
()
()
()
(1,36,2,3)(4,39,19,11,31,47,42,40,28,37,14,6,30,22,15,33,38,48,21,44,23,27\
  ,45,32,13,25,41,16,18,24,20,12,9,8,49,5,46,34)(7,10,43,50,17,29,26,35)
