/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.ja.JapaneseIterationMarkCharFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractCharFilterFactory;
import org.opensearch.index.analysis.NormalizingCharFilterFactory;

public class KuromojiIterationMarkCharFilterFactory
extends AbstractCharFilterFactory
implements NormalizingCharFilterFactory {
    private final boolean normalizeKanji;
    private final boolean normalizeKana;

    public KuromojiIterationMarkCharFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name);
        this.normalizeKanji = settings.getAsBoolean("normalize_kanji", Boolean.valueOf(true));
        this.normalizeKana = settings.getAsBoolean("normalize_kana", Boolean.valueOf(true));
    }

    public Reader create(Reader reader) {
        return new JapaneseIterationMarkCharFilter(reader, this.normalizeKanji, this.normalizeKana);
    }
}

