/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.hll.DirectHllArray;
import com.yahoo.sketches.hll.Hll6Array;
import com.yahoo.sketches.hll.HllPairIterator;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class DirectHll6Array
extends DirectHllArray {
    DirectHll6Array(int lgConfigK, WritableMemory wmem) {
        super(lgConfigK, TgtHllType.HLL_6, wmem);
    }

    DirectHll6Array(int lgConfigK, Memory mem) {
        super(lgConfigK, TgtHllType.HLL_6, mem);
    }

    @Override
    HllSketchImpl copy() {
        return Hll6Array.heapify(this.mem);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getLow26(coupon) & configKmask;
        int newVal = HllUtil.getValue(coupon);
        assert (newVal > 0);
        int curVal = this.getSlot(slotNo);
        if (newVal > curVal) {
            this.putSlot(slotNo, newVal);
            DirectHll6Array.hipAndKxQIncrementalUpdate(this, curVal, newVal);
            if (curVal == 0) {
                this.decNumAtCurMin();
                assert (this.getNumAtCurMin() >= 0);
            }
        }
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll6Array.hll6ArrBytes(this.lgConfigK);
    }

    @Override
    PairIterator iterator() {
        return new DirectHll6Iterator(1 << this.lgConfigK);
    }

    @Override
    final int getSlot(int slotNo) {
        return Hll6Array.get6Bit(this.mem, PreambleUtil.HLL_BYTE_ARR_START, slotNo);
    }

    @Override
    final void putSlot(int slotNo, int value) {
        Hll6Array.put6Bit(this.wmem, PreambleUtil.HLL_BYTE_ARR_START, slotNo, value);
    }

    final class DirectHll6Iterator
    extends HllPairIterator {
        int bitOffset;

        DirectHll6Iterator(int lengthPairs) {
            super(lengthPairs);
            this.bitOffset = -6;
        }

        @Override
        int value() {
            this.bitOffset += 6;
            short tmp = DirectHll6Array.this.mem.getShort((long)(PreambleUtil.HLL_BYTE_ARR_START + this.bitOffset / 8));
            int shift = this.bitOffset % 8 & 7;
            return tmp >>> shift & 0x3F;
        }
    }
}

