/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CgroupMemoryStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CgroupMemoryStats> {
    @Nullable
    private final String controlGroup;
    @Nullable
    private final String limitInBytes;
    @Nullable
    private final String usageInBytes;
    public static final JsonpDeserializer<CgroupMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CgroupMemoryStats::setupCgroupMemoryStatsDeserializer);

    private CgroupMemoryStats(Builder builder) {
        this.controlGroup = builder.controlGroup;
        this.limitInBytes = builder.limitInBytes;
        this.usageInBytes = builder.usageInBytes;
    }

    public static CgroupMemoryStats of(Function<Builder, ObjectBuilder<CgroupMemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String controlGroup() {
        return this.controlGroup;
    }

    @Nullable
    public final String limitInBytes() {
        return this.limitInBytes;
    }

    @Nullable
    public final String usageInBytes() {
        return this.usageInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.controlGroup != null) {
            generator.writeKey("control_group");
            generator.write(this.controlGroup);
        }
        if (this.limitInBytes != null) {
            generator.writeKey("limit_in_bytes");
            generator.write(this.limitInBytes);
        }
        if (this.usageInBytes != null) {
            generator.writeKey("usage_in_bytes");
            generator.write(this.usageInBytes);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCgroupMemoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::controlGroup, JsonpDeserializer.stringDeserializer(), "control_group");
        op.add(Builder::limitInBytes, JsonpDeserializer.stringDeserializer(), "limit_in_bytes");
        op.add(Builder::usageInBytes, JsonpDeserializer.stringDeserializer(), "usage_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.controlGroup);
        result = 31 * result + Objects.hashCode(this.limitInBytes);
        result = 31 * result + Objects.hashCode(this.usageInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CgroupMemoryStats other = (CgroupMemoryStats)o;
        return Objects.equals(this.controlGroup, other.controlGroup) && Objects.equals(this.limitInBytes, other.limitInBytes) && Objects.equals(this.usageInBytes, other.usageInBytes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CgroupMemoryStats> {
        @Nullable
        private String controlGroup;
        @Nullable
        private String limitInBytes;
        @Nullable
        private String usageInBytes;

        public Builder() {
        }

        private Builder(CgroupMemoryStats o) {
            this.controlGroup = o.controlGroup;
            this.limitInBytes = o.limitInBytes;
            this.usageInBytes = o.usageInBytes;
        }

        private Builder(Builder o) {
            this.controlGroup = o.controlGroup;
            this.limitInBytes = o.limitInBytes;
            this.usageInBytes = o.usageInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder controlGroup(@Nullable String value) {
            this.controlGroup = value;
            return this;
        }

        @Nonnull
        public final Builder limitInBytes(@Nullable String value) {
            this.limitInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder usageInBytes(@Nullable String value) {
            this.usageInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public CgroupMemoryStats build() {
            this._checkSingleUse();
            return new CgroupMemoryStats(this);
        }
    }
}

