/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly.evaluation;

import java.util.function.ToDoubleBiFunction;
import org.tribuo.Output;
import org.tribuo.anomaly.AnomalyFactory;
import org.tribuo.anomaly.Event;
import org.tribuo.anomaly.evaluation.AnomalyMetric;
import org.tribuo.evaluation.metrics.MetricTarget;

public enum AnomalyMetrics {
    TP((t, c) -> c.getTruePositive()),
    FP((t, c) -> c.getFalsePositive()),
    TN((t, c) -> c.getTrueNegative()),
    FN((t, c) -> c.getFalseNegative()),
    PRECISION((t, c) -> (double)c.getTruePositive() / (double)(c.getTruePositive() + c.getFalsePositive())),
    RECALL((t, c) -> (double)c.getTruePositive() / (double)(c.getTruePositive() + c.getFalseNegative())),
    F1((t, c) -> 2.0 * (double)c.getTruePositive() / (2.0 * (double)c.getTruePositive() + (double)c.getFalseNegative() + (double)c.getFalsePositive()));

    private final ToDoubleBiFunction<MetricTarget<Event>, AnomalyMetric.Context> impl;
    private final AnomalyMetric metric;

    private AnomalyMetrics(ToDoubleBiFunction<MetricTarget<Event>, AnomalyMetric.Context> impl) {
        this.impl = impl;
        this.metric = new AnomalyMetric((MetricTarget<Event>)new MetricTarget((Output)AnomalyFactory.ANOMALOUS_EVENT), this.name(), this.impl);
    }

    AnomalyMetric asMetric() {
        return this.metric;
    }
}

