/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.REMOVE_JSONPATH)
public class MLRemoveJsonPathProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLRemoveJsonPathProcessor.class);
    private final List<String> paths;

    public MLRemoveJsonPathProcessor(Map<String, Object> config) {
        super(config);
        this.paths = (List)config.get("paths");
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("paths")) {
            throw new IllegalArgumentException("'paths' is required for remove_jsonpath processor");
        }
        Object pathsValue = this.config.get("paths");
        if (pathsValue == null) {
            throw new IllegalArgumentException("'paths' cannot be null for remove_jsonpath processor");
        }
        if (!(pathsValue instanceof List)) {
            throw new IllegalArgumentException("'paths' must be a list for remove_jsonpath processor");
        }
        List pathsList = (List)pathsValue;
        if (pathsList.isEmpty()) {
            throw new IllegalArgumentException("'paths' cannot be empty for remove_jsonpath processor");
        }
        for (Object path : pathsList) {
            if (path != null && path instanceof String && !((String)path).isBlank()) continue;
            throw new IllegalArgumentException("Each path in 'paths' must be a non-empty string");
        }
    }

    @Override
    public Object process(Object input) {
        try {
            String jsonStr = StringUtils.toJson((Object)input);
            DocumentContext context = JsonPath.parse((String)jsonStr);
            for (String path : this.paths) {
                try {
                    context.delete(path, new Predicate[0]);
                }
                catch (Exception e) {
                    log.warn("Failed to remove JsonPath {}: {}", (Object)path, (Object)e.getMessage());
                }
            }
            return context.json();
        }
        catch (Exception e) {
            log.warn("Failed to process input for remove_jsonpath: {}", (Object)e.getMessage());
            return input;
        }
    }
}

