import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateDistributionWithTagsRequestFilterSensitiveLog, CreateDistributionWithTagsResultFilterSensitiveLog, } from "../models/models_0";
import { de_CreateDistributionWithTagsCommand, se_CreateDistributionWithTagsCommand } from "../protocols/Aws_restXml";
export { $Command };
export class CreateDistributionWithTagsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "CreateDistributionWithTags", {})
    .n("CloudFrontClient", "CreateDistributionWithTagsCommand")
    .f(CreateDistributionWithTagsRequestFilterSensitiveLog, CreateDistributionWithTagsResultFilterSensitiveLog)
    .ser(se_CreateDistributionWithTagsCommand)
    .de(de_CreateDistributionWithTagsCommand)
    .build() {
}
