import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListKeyValueStoresCommand, se_ListKeyValueStoresCommand } from "../protocols/Aws_restXml";
export { $Command };
export class ListKeyValueStoresCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListKeyValueStores", {})
    .n("CloudFrontClient", "ListKeyValueStoresCommand")
    .f(void 0, void 0)
    .ser(se_ListKeyValueStoresCommand)
    .de(de_ListKeyValueStoresCommand)
    .build() {
}
