import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFrontServiceException as __BaseException } from "./CloudFrontServiceException";
import {
  ActiveTrustedSigners,
  Aliases,
  AliasICPRecordal,
  AnycastIpList,
  AnycastIpListCollection,
  CacheBehaviors,
  CachePolicy,
  CachePolicyConfig,
  CachePolicyList,
  CachePolicyType,
  CloudFrontOriginAccessIdentity,
  CloudFrontOriginAccessIdentityConfig,
  ConnectionGroup,
  ConnectionMode,
  ContentTypeProfileConfig,
  ContinuousDeploymentPolicy,
  ContinuousDeploymentPolicyConfig,
  CookieNames,
  CustomErrorResponses,
  Customizations,
  DefaultCacheBehavior,
  Distribution,
  DistributionConfig,
  DistributionTenant,
  DomainResult,
  EncryptionEntities,
  FieldLevelEncryption,
  FieldLevelEncryptionConfig,
  FieldLevelEncryptionProfile,
  FieldLevelEncryptionProfileConfig,
  FunctionStage,
  FunctionSummary,
  Headers,
  HttpVersion,
  Invalidation,
  KeyGroup,
  KeyGroupConfig,
  KeyValueStore,
  MonitoringSubscription,
  OriginAccessControl,
  OriginAccessControlConfig,
  OriginAccessControlOriginTypes,
  OriginAccessControlSigningBehaviors,
  OriginAccessControlSigningProtocols,
  OriginGroups,
  OriginProtocolPolicy,
  Origins,
  OriginSslProtocols,
  PriceClass,
  QueryArgProfileConfig,
  QueryStringNames,
  ResponseHeadersPolicyAccessControlAllowMethodsValues,
  Restrictions,
  Tags,
  TrustedSigners,
  ValidationTokenHost,
  ViewerCertificate,
} from "./models_0";
export declare class OriginAccessControlAlreadyExists extends __BaseException {
  readonly name: "OriginAccessControlAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      OriginAccessControlAlreadyExists,
      __BaseException
    >
  );
}
export declare class TooManyOriginAccessControls extends __BaseException {
  readonly name: "TooManyOriginAccessControls";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyOriginAccessControls, __BaseException>
  );
}
export declare const OriginRequestPolicyCookieBehavior: {
  readonly all: "all";
  readonly allExcept: "allExcept";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type OriginRequestPolicyCookieBehavior =
  (typeof OriginRequestPolicyCookieBehavior)[keyof typeof OriginRequestPolicyCookieBehavior];
export interface OriginRequestPolicyCookiesConfig {
  CookieBehavior: OriginRequestPolicyCookieBehavior | undefined;
  Cookies?: CookieNames | undefined;
}
export declare const OriginRequestPolicyHeaderBehavior: {
  readonly allExcept: "allExcept";
  readonly allViewer: "allViewer";
  readonly allViewerAndWhitelistCloudFront: "allViewerAndWhitelistCloudFront";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type OriginRequestPolicyHeaderBehavior =
  (typeof OriginRequestPolicyHeaderBehavior)[keyof typeof OriginRequestPolicyHeaderBehavior];
export interface OriginRequestPolicyHeadersConfig {
  HeaderBehavior: OriginRequestPolicyHeaderBehavior | undefined;
  Headers?: Headers | undefined;
}
export declare const OriginRequestPolicyQueryStringBehavior: {
  readonly all: "all";
  readonly allExcept: "allExcept";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type OriginRequestPolicyQueryStringBehavior =
  (typeof OriginRequestPolicyQueryStringBehavior)[keyof typeof OriginRequestPolicyQueryStringBehavior];
export interface OriginRequestPolicyQueryStringsConfig {
  QueryStringBehavior: OriginRequestPolicyQueryStringBehavior | undefined;
  QueryStrings?: QueryStringNames | undefined;
}
export interface OriginRequestPolicyConfig {
  Comment?: string | undefined;
  Name: string | undefined;
  HeadersConfig: OriginRequestPolicyHeadersConfig | undefined;
  CookiesConfig: OriginRequestPolicyCookiesConfig | undefined;
  QueryStringsConfig: OriginRequestPolicyQueryStringsConfig | undefined;
}
export interface CreateOriginRequestPolicyRequest {
  OriginRequestPolicyConfig: OriginRequestPolicyConfig | undefined;
}
export interface OriginRequestPolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  OriginRequestPolicyConfig: OriginRequestPolicyConfig | undefined;
}
export interface CreateOriginRequestPolicyResult {
  OriginRequestPolicy?: OriginRequestPolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class OriginRequestPolicyAlreadyExists extends __BaseException {
  readonly name: "OriginRequestPolicyAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      OriginRequestPolicyAlreadyExists,
      __BaseException
    >
  );
}
export declare class TooManyCookiesInOriginRequestPolicy extends __BaseException {
  readonly name: "TooManyCookiesInOriginRequestPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyCookiesInOriginRequestPolicy,
      __BaseException
    >
  );
}
export declare class TooManyHeadersInOriginRequestPolicy extends __BaseException {
  readonly name: "TooManyHeadersInOriginRequestPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyHeadersInOriginRequestPolicy,
      __BaseException
    >
  );
}
export declare class TooManyOriginRequestPolicies extends __BaseException {
  readonly name: "TooManyOriginRequestPolicies";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyOriginRequestPolicies, __BaseException>
  );
}
export declare class TooManyQueryStringsInOriginRequestPolicy extends __BaseException {
  readonly name: "TooManyQueryStringsInOriginRequestPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyQueryStringsInOriginRequestPolicy,
      __BaseException
    >
  );
}
export interface PublicKeyConfig {
  CallerReference: string | undefined;
  Name: string | undefined;
  EncodedKey: string | undefined;
  Comment?: string | undefined;
}
export interface CreatePublicKeyRequest {
  PublicKeyConfig: PublicKeyConfig | undefined;
}
export interface PublicKey {
  Id: string | undefined;
  CreatedTime: Date | undefined;
  PublicKeyConfig: PublicKeyConfig | undefined;
}
export interface CreatePublicKeyResult {
  PublicKey?: PublicKey | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class PublicKeyAlreadyExists extends __BaseException {
  readonly name: "PublicKeyAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<PublicKeyAlreadyExists, __BaseException>
  );
}
export declare class TooManyPublicKeys extends __BaseException {
  readonly name: "TooManyPublicKeys";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<TooManyPublicKeys, __BaseException>);
}
export interface KinesisStreamConfig {
  RoleARN: string | undefined;
  StreamARN: string | undefined;
}
export interface EndPoint {
  StreamType: string | undefined;
  KinesisStreamConfig?: KinesisStreamConfig | undefined;
}
export interface CreateRealtimeLogConfigRequest {
  EndPoints: EndPoint[] | undefined;
  Fields: string[] | undefined;
  Name: string | undefined;
  SamplingRate: number | undefined;
}
export interface RealtimeLogConfig {
  ARN: string | undefined;
  Name: string | undefined;
  SamplingRate: number | undefined;
  EndPoints: EndPoint[] | undefined;
  Fields: string[] | undefined;
}
export interface CreateRealtimeLogConfigResult {
  RealtimeLogConfig?: RealtimeLogConfig | undefined;
}
export declare class RealtimeLogConfigAlreadyExists extends __BaseException {
  readonly name: "RealtimeLogConfigAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<RealtimeLogConfigAlreadyExists, __BaseException>
  );
}
export declare class TooManyRealtimeLogConfigs extends __BaseException {
  readonly name: "TooManyRealtimeLogConfigs";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyRealtimeLogConfigs, __BaseException>
  );
}
export interface ResponseHeadersPolicyAccessControlAllowHeaders {
  Quantity: number | undefined;
  Items: string[] | undefined;
}
export interface ResponseHeadersPolicyAccessControlAllowMethods {
  Quantity: number | undefined;
  Items: ResponseHeadersPolicyAccessControlAllowMethodsValues[] | undefined;
}
export interface ResponseHeadersPolicyAccessControlAllowOrigins {
  Quantity: number | undefined;
  Items: string[] | undefined;
}
export interface ResponseHeadersPolicyAccessControlExposeHeaders {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ResponseHeadersPolicyCorsConfig {
  AccessControlAllowOrigins:
    | ResponseHeadersPolicyAccessControlAllowOrigins
    | undefined;
  AccessControlAllowHeaders:
    | ResponseHeadersPolicyAccessControlAllowHeaders
    | undefined;
  AccessControlAllowMethods:
    | ResponseHeadersPolicyAccessControlAllowMethods
    | undefined;
  AccessControlAllowCredentials: boolean | undefined;
  AccessControlExposeHeaders?:
    | ResponseHeadersPolicyAccessControlExposeHeaders
    | undefined;
  AccessControlMaxAgeSec?: number | undefined;
  OriginOverride: boolean | undefined;
}
export interface ResponseHeadersPolicyCustomHeader {
  Header: string | undefined;
  Value: string | undefined;
  Override: boolean | undefined;
}
export interface ResponseHeadersPolicyCustomHeadersConfig {
  Quantity: number | undefined;
  Items?: ResponseHeadersPolicyCustomHeader[] | undefined;
}
export interface ResponseHeadersPolicyRemoveHeader {
  Header: string | undefined;
}
export interface ResponseHeadersPolicyRemoveHeadersConfig {
  Quantity: number | undefined;
  Items?: ResponseHeadersPolicyRemoveHeader[] | undefined;
}
export interface ResponseHeadersPolicyContentSecurityPolicy {
  Override: boolean | undefined;
  ContentSecurityPolicy: string | undefined;
}
export interface ResponseHeadersPolicyContentTypeOptions {
  Override: boolean | undefined;
}
export declare const FrameOptionsList: {
  readonly DENY: "DENY";
  readonly SAMEORIGIN: "SAMEORIGIN";
};
export type FrameOptionsList =
  (typeof FrameOptionsList)[keyof typeof FrameOptionsList];
export interface ResponseHeadersPolicyFrameOptions {
  Override: boolean | undefined;
  FrameOption: FrameOptionsList | undefined;
}
export declare const ReferrerPolicyList: {
  readonly no_referrer: "no-referrer";
  readonly no_referrer_when_downgrade: "no-referrer-when-downgrade";
  readonly origin: "origin";
  readonly origin_when_cross_origin: "origin-when-cross-origin";
  readonly same_origin: "same-origin";
  readonly strict_origin: "strict-origin";
  readonly strict_origin_when_cross_origin: "strict-origin-when-cross-origin";
  readonly unsafe_url: "unsafe-url";
};
export type ReferrerPolicyList =
  (typeof ReferrerPolicyList)[keyof typeof ReferrerPolicyList];
export interface ResponseHeadersPolicyReferrerPolicy {
  Override: boolean | undefined;
  ReferrerPolicy: ReferrerPolicyList | undefined;
}
export interface ResponseHeadersPolicyStrictTransportSecurity {
  Override: boolean | undefined;
  IncludeSubdomains?: boolean | undefined;
  Preload?: boolean | undefined;
  AccessControlMaxAgeSec: number | undefined;
}
export interface ResponseHeadersPolicyXSSProtection {
  Override: boolean | undefined;
  Protection: boolean | undefined;
  ModeBlock?: boolean | undefined;
  ReportUri?: string | undefined;
}
export interface ResponseHeadersPolicySecurityHeadersConfig {
  XSSProtection?: ResponseHeadersPolicyXSSProtection | undefined;
  FrameOptions?: ResponseHeadersPolicyFrameOptions | undefined;
  ReferrerPolicy?: ResponseHeadersPolicyReferrerPolicy | undefined;
  ContentSecurityPolicy?:
    | ResponseHeadersPolicyContentSecurityPolicy
    | undefined;
  ContentTypeOptions?: ResponseHeadersPolicyContentTypeOptions | undefined;
  StrictTransportSecurity?:
    | ResponseHeadersPolicyStrictTransportSecurity
    | undefined;
}
export interface ResponseHeadersPolicyServerTimingHeadersConfig {
  Enabled: boolean | undefined;
  SamplingRate?: number | undefined;
}
export interface ResponseHeadersPolicyConfig {
  Comment?: string | undefined;
  Name: string | undefined;
  CorsConfig?: ResponseHeadersPolicyCorsConfig | undefined;
  SecurityHeadersConfig?:
    | ResponseHeadersPolicySecurityHeadersConfig
    | undefined;
  ServerTimingHeadersConfig?:
    | ResponseHeadersPolicyServerTimingHeadersConfig
    | undefined;
  CustomHeadersConfig?: ResponseHeadersPolicyCustomHeadersConfig | undefined;
  RemoveHeadersConfig?: ResponseHeadersPolicyRemoveHeadersConfig | undefined;
}
export interface CreateResponseHeadersPolicyRequest {
  ResponseHeadersPolicyConfig: ResponseHeadersPolicyConfig | undefined;
}
export interface ResponseHeadersPolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  ResponseHeadersPolicyConfig: ResponseHeadersPolicyConfig | undefined;
}
export interface CreateResponseHeadersPolicyResult {
  ResponseHeadersPolicy?: ResponseHeadersPolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class ResponseHeadersPolicyAlreadyExists extends __BaseException {
  readonly name: "ResponseHeadersPolicyAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      ResponseHeadersPolicyAlreadyExists,
      __BaseException
    >
  );
}
export declare class TooLongCSPInResponseHeadersPolicy extends __BaseException {
  readonly name: "TooLongCSPInResponseHeadersPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooLongCSPInResponseHeadersPolicy,
      __BaseException
    >
  );
}
export declare class TooManyCustomHeadersInResponseHeadersPolicy extends __BaseException {
  readonly name: "TooManyCustomHeadersInResponseHeadersPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyCustomHeadersInResponseHeadersPolicy,
      __BaseException
    >
  );
}
export declare class TooManyRemoveHeadersInResponseHeadersPolicy extends __BaseException {
  readonly name: "TooManyRemoveHeadersInResponseHeadersPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyRemoveHeadersInResponseHeadersPolicy,
      __BaseException
    >
  );
}
export declare class TooManyResponseHeadersPolicies extends __BaseException {
  readonly name: "TooManyResponseHeadersPolicies";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyResponseHeadersPolicies, __BaseException>
  );
}
export interface StreamingLoggingConfig {
  Enabled: boolean | undefined;
  Bucket: string | undefined;
  Prefix: string | undefined;
}
export interface S3Origin {
  DomainName: string | undefined;
  OriginAccessIdentity: string | undefined;
}
export interface StreamingDistributionConfig {
  CallerReference: string | undefined;
  S3Origin: S3Origin | undefined;
  Aliases?: Aliases | undefined;
  Comment: string | undefined;
  Logging?: StreamingLoggingConfig | undefined;
  TrustedSigners: TrustedSigners | undefined;
  PriceClass?: PriceClass | undefined;
  Enabled: boolean | undefined;
}
export interface CreateStreamingDistributionRequest {
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
}
export interface StreamingDistribution {
  Id: string | undefined;
  ARN: string | undefined;
  Status: string | undefined;
  LastModifiedTime?: Date | undefined;
  DomainName: string | undefined;
  ActiveTrustedSigners: ActiveTrustedSigners | undefined;
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
}
export interface CreateStreamingDistributionResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class StreamingDistributionAlreadyExists extends __BaseException {
  readonly name: "StreamingDistributionAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      StreamingDistributionAlreadyExists,
      __BaseException
    >
  );
}
export declare class TooManyStreamingDistributionCNAMEs extends __BaseException {
  readonly name: "TooManyStreamingDistributionCNAMEs";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyStreamingDistributionCNAMEs,
      __BaseException
    >
  );
}
export declare class TooManyStreamingDistributions extends __BaseException {
  readonly name: "TooManyStreamingDistributions";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyStreamingDistributions, __BaseException>
  );
}
export interface StreamingDistributionConfigWithTags {
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
  Tags: Tags | undefined;
}
export interface CreateStreamingDistributionWithTagsRequest {
  StreamingDistributionConfigWithTags:
    | StreamingDistributionConfigWithTags
    | undefined;
}
export interface CreateStreamingDistributionWithTagsResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface VpcOriginEndpointConfig {
  Name: string | undefined;
  Arn: string | undefined;
  HTTPPort: number | undefined;
  HTTPSPort: number | undefined;
  OriginProtocolPolicy: OriginProtocolPolicy | undefined;
  OriginSslProtocols?: OriginSslProtocols | undefined;
}
export interface CreateVpcOriginRequest {
  VpcOriginEndpointConfig: VpcOriginEndpointConfig | undefined;
  Tags?: Tags | undefined;
}
export interface VpcOrigin {
  Id: string | undefined;
  Arn: string | undefined;
  AccountId?: string | undefined;
  Status: string | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  VpcOriginEndpointConfig: VpcOriginEndpointConfig | undefined;
}
export interface CreateVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface DeleteAnycastIpListRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export declare class IllegalDelete extends __BaseException {
  readonly name: "IllegalDelete";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<IllegalDelete, __BaseException>);
}
export interface DeleteCachePolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class CloudFrontOriginAccessIdentityInUse extends __BaseException {
  readonly name: "CloudFrontOriginAccessIdentityInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      CloudFrontOriginAccessIdentityInUse,
      __BaseException
    >
  );
}
export interface DeleteCloudFrontOriginAccessIdentityRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class NoSuchCloudFrontOriginAccessIdentity extends __BaseException {
  readonly name: "NoSuchCloudFrontOriginAccessIdentity";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      NoSuchCloudFrontOriginAccessIdentity,
      __BaseException
    >
  );
}
export interface DeleteConnectionGroupRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export declare class ResourceNotDisabled extends __BaseException {
  readonly name: "ResourceNotDisabled";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ResourceNotDisabled, __BaseException>
  );
}
export interface DeleteContinuousDeploymentPolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteDistributionRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class DistributionNotDisabled extends __BaseException {
  readonly name: "DistributionNotDisabled";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<DistributionNotDisabled, __BaseException>
  );
}
export declare class ResourceInUse extends __BaseException {
  readonly name: "ResourceInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<ResourceInUse, __BaseException>);
}
export interface DeleteDistributionTenantRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteFieldLevelEncryptionConfigRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class FieldLevelEncryptionConfigInUse extends __BaseException {
  readonly name: "FieldLevelEncryptionConfigInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      FieldLevelEncryptionConfigInUse,
      __BaseException
    >
  );
}
export interface DeleteFieldLevelEncryptionProfileRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class FieldLevelEncryptionProfileInUse extends __BaseException {
  readonly name: "FieldLevelEncryptionProfileInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      FieldLevelEncryptionProfileInUse,
      __BaseException
    >
  );
}
export interface DeleteFunctionRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
}
export declare class FunctionInUse extends __BaseException {
  readonly name: "FunctionInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<FunctionInUse, __BaseException>);
}
export declare class NoSuchFunctionExists extends __BaseException {
  readonly name: "NoSuchFunctionExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchFunctionExists, __BaseException>
  );
}
export interface DeleteKeyGroupRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class NoSuchResource extends __BaseException {
  readonly name: "NoSuchResource";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<NoSuchResource, __BaseException>);
}
export interface DeleteKeyValueStoreRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteMonitoringSubscriptionRequest {
  DistributionId: string | undefined;
}
export interface DeleteMonitoringSubscriptionResult {}
export declare class NoSuchMonitoringSubscription extends __BaseException {
  readonly name: "NoSuchMonitoringSubscription";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchMonitoringSubscription, __BaseException>
  );
}
export interface DeleteOriginAccessControlRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class NoSuchOriginAccessControl extends __BaseException {
  readonly name: "NoSuchOriginAccessControl";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchOriginAccessControl, __BaseException>
  );
}
export declare class OriginAccessControlInUse extends __BaseException {
  readonly name: "OriginAccessControlInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<OriginAccessControlInUse, __BaseException>
  );
}
export interface DeleteOriginRequestPolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class OriginRequestPolicyInUse extends __BaseException {
  readonly name: "OriginRequestPolicyInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<OriginRequestPolicyInUse, __BaseException>
  );
}
export interface DeletePublicKeyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class PublicKeyInUse extends __BaseException {
  readonly name: "PublicKeyInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<PublicKeyInUse, __BaseException>);
}
export interface DeleteRealtimeLogConfigRequest {
  Name?: string | undefined;
  ARN?: string | undefined;
}
export declare class RealtimeLogConfigInUse extends __BaseException {
  readonly name: "RealtimeLogConfigInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<RealtimeLogConfigInUse, __BaseException>
  );
}
export interface DeleteResourcePolicyRequest {
  ResourceArn: string | undefined;
}
export interface DeleteResponseHeadersPolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class ResponseHeadersPolicyInUse extends __BaseException {
  readonly name: "ResponseHeadersPolicyInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ResponseHeadersPolicyInUse, __BaseException>
  );
}
export interface DeleteStreamingDistributionRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export declare class NoSuchStreamingDistribution extends __BaseException {
  readonly name: "NoSuchStreamingDistribution";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchStreamingDistribution, __BaseException>
  );
}
export declare class StreamingDistributionNotDisabled extends __BaseException {
  readonly name: "StreamingDistributionNotDisabled";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      StreamingDistributionNotDisabled,
      __BaseException
    >
  );
}
export interface DeleteVpcOriginRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  ETag?: string | undefined;
}
export interface DescribeFunctionRequest {
  Name: string | undefined;
  Stage?: FunctionStage | undefined;
}
export interface DescribeFunctionResult {
  FunctionSummary?: FunctionSummary | undefined;
  ETag?: string | undefined;
}
export interface DescribeKeyValueStoreRequest {
  Name: string | undefined;
}
export interface DescribeKeyValueStoreResult {
  KeyValueStore?: KeyValueStore | undefined;
  ETag?: string | undefined;
}
export interface DisassociateDistributionTenantWebACLRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DisassociateDistributionTenantWebACLResult {
  Id?: string | undefined;
  ETag?: string | undefined;
}
export interface DisassociateDistributionWebACLRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DisassociateDistributionWebACLResult {
  Id?: string | undefined;
  ETag?: string | undefined;
}
export interface GetAnycastIpListRequest {
  Id: string | undefined;
}
export interface GetAnycastIpListResult {
  AnycastIpList?: AnycastIpList | undefined;
  ETag?: string | undefined;
}
export interface GetCachePolicyRequest {
  Id: string | undefined;
}
export interface GetCachePolicyResult {
  CachePolicy?: CachePolicy | undefined;
  ETag?: string | undefined;
}
export interface GetCachePolicyConfigRequest {
  Id: string | undefined;
}
export interface GetCachePolicyConfigResult {
  CachePolicyConfig?: CachePolicyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityRequest {
  Id: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityResult {
  CloudFrontOriginAccessIdentity?: CloudFrontOriginAccessIdentity | undefined;
  ETag?: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityConfigRequest {
  Id: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityConfigResult {
  CloudFrontOriginAccessIdentityConfig?:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
  ETag?: string | undefined;
}
export interface GetConnectionGroupRequest {
  Identifier: string | undefined;
}
export interface GetConnectionGroupResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export interface GetConnectionGroupByRoutingEndpointRequest {
  RoutingEndpoint: string | undefined;
}
export interface GetConnectionGroupByRoutingEndpointResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export interface GetContinuousDeploymentPolicyRequest {
  Id: string | undefined;
}
export interface GetContinuousDeploymentPolicyResult {
  ContinuousDeploymentPolicy?: ContinuousDeploymentPolicy | undefined;
  ETag?: string | undefined;
}
export interface GetContinuousDeploymentPolicyConfigRequest {
  Id: string | undefined;
}
export interface GetContinuousDeploymentPolicyConfigResult {
  ContinuousDeploymentPolicyConfig?:
    | ContinuousDeploymentPolicyConfig
    | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionRequest {
  Id: string | undefined;
}
export interface GetDistributionResult {
  Distribution?: Distribution | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionConfigRequest {
  Id: string | undefined;
}
export interface GetDistributionConfigResult {
  DistributionConfig?: DistributionConfig | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionTenantRequest {
  Identifier: string | undefined;
}
export interface GetDistributionTenantResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionTenantByDomainRequest {
  Domain: string | undefined;
}
export interface GetDistributionTenantByDomainResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionResult {
  FieldLevelEncryption?: FieldLevelEncryption | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionConfigRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionConfigResult {
  FieldLevelEncryptionConfig?: FieldLevelEncryptionConfig | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionProfileRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionProfileResult {
  FieldLevelEncryptionProfile?: FieldLevelEncryptionProfile | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionProfileConfigRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionProfileConfigResult {
  FieldLevelEncryptionProfileConfig?:
    | FieldLevelEncryptionProfileConfig
    | undefined;
  ETag?: string | undefined;
}
export interface GetFunctionRequest {
  Name: string | undefined;
  Stage?: FunctionStage | undefined;
}
export interface GetFunctionResult {
  FunctionCode?: Uint8Array | undefined;
  ETag?: string | undefined;
  ContentType?: string | undefined;
}
export interface GetInvalidationRequest {
  DistributionId: string | undefined;
  Id: string | undefined;
}
export interface GetInvalidationResult {
  Invalidation?: Invalidation | undefined;
}
export declare class NoSuchInvalidation extends __BaseException {
  readonly name: "NoSuchInvalidation";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<NoSuchInvalidation, __BaseException>);
}
export interface GetInvalidationForDistributionTenantRequest {
  DistributionTenantId: string | undefined;
  Id: string | undefined;
}
export interface GetInvalidationForDistributionTenantResult {
  Invalidation?: Invalidation | undefined;
}
export interface GetKeyGroupRequest {
  Id: string | undefined;
}
export interface GetKeyGroupResult {
  KeyGroup?: KeyGroup | undefined;
  ETag?: string | undefined;
}
export interface GetKeyGroupConfigRequest {
  Id: string | undefined;
}
export interface GetKeyGroupConfigResult {
  KeyGroupConfig?: KeyGroupConfig | undefined;
  ETag?: string | undefined;
}
export interface GetManagedCertificateDetailsRequest {
  Identifier: string | undefined;
}
export declare const ManagedCertificateStatus: {
  readonly Expired: "expired";
  readonly Failed: "failed";
  readonly Inactive: "inactive";
  readonly Issued: "issued";
  readonly PendingValidation: "pending-validation";
  readonly Revoked: "revoked";
  readonly ValidationTimedOut: "validation-timed-out";
};
export type ManagedCertificateStatus =
  (typeof ManagedCertificateStatus)[keyof typeof ManagedCertificateStatus];
export interface ValidationTokenDetail {
  Domain: string | undefined;
  RedirectTo?: string | undefined;
  RedirectFrom?: string | undefined;
}
export interface ManagedCertificateDetails {
  CertificateArn?: string | undefined;
  CertificateStatus?: ManagedCertificateStatus | undefined;
  ValidationTokenHost?: ValidationTokenHost | undefined;
  ValidationTokenDetails?: ValidationTokenDetail[] | undefined;
}
export interface GetManagedCertificateDetailsResult {
  ManagedCertificateDetails?: ManagedCertificateDetails | undefined;
}
export interface GetMonitoringSubscriptionRequest {
  DistributionId: string | undefined;
}
export interface GetMonitoringSubscriptionResult {
  MonitoringSubscription?: MonitoringSubscription | undefined;
}
export interface GetOriginAccessControlRequest {
  Id: string | undefined;
}
export interface GetOriginAccessControlResult {
  OriginAccessControl?: OriginAccessControl | undefined;
  ETag?: string | undefined;
}
export interface GetOriginAccessControlConfigRequest {
  Id: string | undefined;
}
export interface GetOriginAccessControlConfigResult {
  OriginAccessControlConfig?: OriginAccessControlConfig | undefined;
  ETag?: string | undefined;
}
export interface GetOriginRequestPolicyRequest {
  Id: string | undefined;
}
export interface GetOriginRequestPolicyResult {
  OriginRequestPolicy?: OriginRequestPolicy | undefined;
  ETag?: string | undefined;
}
export interface GetOriginRequestPolicyConfigRequest {
  Id: string | undefined;
}
export interface GetOriginRequestPolicyConfigResult {
  OriginRequestPolicyConfig?: OriginRequestPolicyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetPublicKeyRequest {
  Id: string | undefined;
}
export interface GetPublicKeyResult {
  PublicKey?: PublicKey | undefined;
  ETag?: string | undefined;
}
export interface GetPublicKeyConfigRequest {
  Id: string | undefined;
}
export interface GetPublicKeyConfigResult {
  PublicKeyConfig?: PublicKeyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetRealtimeLogConfigRequest {
  Name?: string | undefined;
  ARN?: string | undefined;
}
export interface GetRealtimeLogConfigResult {
  RealtimeLogConfig?: RealtimeLogConfig | undefined;
}
export interface GetResourcePolicyRequest {
  ResourceArn: string | undefined;
}
export interface GetResourcePolicyResult {
  ResourceArn?: string | undefined;
  PolicyDocument?: string | undefined;
}
export interface GetResponseHeadersPolicyRequest {
  Id: string | undefined;
}
export interface GetResponseHeadersPolicyResult {
  ResponseHeadersPolicy?: ResponseHeadersPolicy | undefined;
  ETag?: string | undefined;
}
export interface GetResponseHeadersPolicyConfigRequest {
  Id: string | undefined;
}
export interface GetResponseHeadersPolicyConfigResult {
  ResponseHeadersPolicyConfig?: ResponseHeadersPolicyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetStreamingDistributionRequest {
  Id: string | undefined;
}
export interface GetStreamingDistributionResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  ETag?: string | undefined;
}
export interface GetStreamingDistributionConfigRequest {
  Id: string | undefined;
}
export interface GetStreamingDistributionConfigResult {
  StreamingDistributionConfig?: StreamingDistributionConfig | undefined;
  ETag?: string | undefined;
}
export interface GetVpcOriginRequest {
  Id: string | undefined;
}
export interface GetVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  ETag?: string | undefined;
}
export interface ListAnycastIpListsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListAnycastIpListsResult {
  AnycastIpLists?: AnycastIpListCollection | undefined;
}
export interface ListCachePoliciesRequest {
  Type?: CachePolicyType | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListCachePoliciesResult {
  CachePolicyList?: CachePolicyList | undefined;
}
export interface ListCloudFrontOriginAccessIdentitiesRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface CloudFrontOriginAccessIdentitySummary {
  Id: string | undefined;
  S3CanonicalUserId: string | undefined;
  Comment: string | undefined;
}
export interface CloudFrontOriginAccessIdentityList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: CloudFrontOriginAccessIdentitySummary[] | undefined;
}
export interface ListCloudFrontOriginAccessIdentitiesResult {
  CloudFrontOriginAccessIdentityList?:
    | CloudFrontOriginAccessIdentityList
    | undefined;
}
export interface ListConflictingAliasesRequest {
  DistributionId: string | undefined;
  Alias: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ConflictingAlias {
  Alias?: string | undefined;
  DistributionId?: string | undefined;
  AccountId?: string | undefined;
}
export interface ConflictingAliasesList {
  NextMarker?: string | undefined;
  MaxItems?: number | undefined;
  Quantity?: number | undefined;
  Items?: ConflictingAlias[] | undefined;
}
export interface ListConflictingAliasesResult {
  ConflictingAliasesList?: ConflictingAliasesList | undefined;
}
export interface ConnectionGroupAssociationFilter {
  AnycastIpListId?: string | undefined;
}
export interface ListConnectionGroupsRequest {
  AssociationFilter?: ConnectionGroupAssociationFilter | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ConnectionGroupSummary {
  Id: string | undefined;
  Name: string | undefined;
  Arn: string | undefined;
  RoutingEndpoint: string | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  ETag: string | undefined;
  AnycastIpListId?: string | undefined;
  Enabled?: boolean | undefined;
  Status?: string | undefined;
  IsDefault?: boolean | undefined;
}
export interface ListConnectionGroupsResult {
  NextMarker?: string | undefined;
  ConnectionGroups?: ConnectionGroupSummary[] | undefined;
}
export interface ListContinuousDeploymentPoliciesRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ContinuousDeploymentPolicySummary {
  ContinuousDeploymentPolicy: ContinuousDeploymentPolicy | undefined;
}
export interface ContinuousDeploymentPolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: ContinuousDeploymentPolicySummary[] | undefined;
}
export interface ListContinuousDeploymentPoliciesResult {
  ContinuousDeploymentPolicyList?: ContinuousDeploymentPolicyList | undefined;
}
export interface ListDistributionsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface DistributionSummary {
  Id: string | undefined;
  ARN: string | undefined;
  ETag?: string | undefined;
  Status: string | undefined;
  LastModifiedTime: Date | undefined;
  DomainName: string | undefined;
  Aliases: Aliases | undefined;
  Origins: Origins | undefined;
  OriginGroups?: OriginGroups | undefined;
  DefaultCacheBehavior: DefaultCacheBehavior | undefined;
  CacheBehaviors: CacheBehaviors | undefined;
  CustomErrorResponses: CustomErrorResponses | undefined;
  Comment: string | undefined;
  PriceClass: PriceClass | undefined;
  Enabled: boolean | undefined;
  ViewerCertificate: ViewerCertificate | undefined;
  Restrictions: Restrictions | undefined;
  WebACLId: string | undefined;
  HttpVersion: HttpVersion | undefined;
  IsIPV6Enabled: boolean | undefined;
  AliasICPRecordals?: AliasICPRecordal[] | undefined;
  Staging: boolean | undefined;
  ConnectionMode?: ConnectionMode | undefined;
  AnycastIpListId?: string | undefined;
}
export interface DistributionList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: DistributionSummary[] | undefined;
}
export interface ListDistributionsResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByAnycastIpListIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  AnycastIpListId: string | undefined;
}
export interface ListDistributionsByAnycastIpListIdResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByCachePolicyIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  CachePolicyId: string | undefined;
}
export interface DistributionIdList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ListDistributionsByCachePolicyIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByConnectionModeRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  ConnectionMode: ConnectionMode | undefined;
}
export interface ListDistributionsByConnectionModeResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByKeyGroupRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  KeyGroupId: string | undefined;
}
export interface ListDistributionsByKeyGroupResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByOriginRequestPolicyIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  OriginRequestPolicyId: string | undefined;
}
export interface ListDistributionsByOriginRequestPolicyIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByOwnedResourceRequest {
  ResourceArn: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface DistributionIdOwner {
  DistributionId: string | undefined;
  OwnerAccountId: string | undefined;
}
export interface DistributionIdOwnerList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: DistributionIdOwner[] | undefined;
}
export interface ListDistributionsByOwnedResourceResult {
  DistributionList?: DistributionIdOwnerList | undefined;
}
export interface ListDistributionsByRealtimeLogConfigRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  RealtimeLogConfigName?: string | undefined;
  RealtimeLogConfigArn?: string | undefined;
}
export interface ListDistributionsByRealtimeLogConfigResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByResponseHeadersPolicyIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  ResponseHeadersPolicyId: string | undefined;
}
export interface ListDistributionsByResponseHeadersPolicyIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByVpcOriginIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  VpcOriginId: string | undefined;
}
export interface ListDistributionsByVpcOriginIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByWebACLIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  WebACLId: string | undefined;
}
export interface ListDistributionsByWebACLIdResult {
  DistributionList?: DistributionList | undefined;
}
export interface DistributionTenantAssociationFilter {
  DistributionId?: string | undefined;
  ConnectionGroupId?: string | undefined;
}
export interface ListDistributionTenantsRequest {
  AssociationFilter?: DistributionTenantAssociationFilter | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface DistributionTenantSummary {
  Id: string | undefined;
  DistributionId: string | undefined;
  Name: string | undefined;
  Arn: string | undefined;
  Domains: DomainResult[] | undefined;
  ConnectionGroupId?: string | undefined;
  Customizations?: Customizations | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  ETag: string | undefined;
  Enabled?: boolean | undefined;
  Status?: string | undefined;
}
export interface ListDistributionTenantsResult {
  NextMarker?: string | undefined;
  DistributionTenantList?: DistributionTenantSummary[] | undefined;
}
export interface ListDistributionTenantsByCustomizationRequest {
  WebACLArn?: string | undefined;
  CertificateArn?: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListDistributionTenantsByCustomizationResult {
  NextMarker?: string | undefined;
  DistributionTenantList?: DistributionTenantSummary[] | undefined;
}
export interface DistributionResourceId {
  DistributionId?: string | undefined;
  DistributionTenantId?: string | undefined;
}
export interface ListDomainConflictsRequest {
  Domain: string | undefined;
  DomainControlValidationResource: DistributionResourceId | undefined;
  MaxItems?: number | undefined;
  Marker?: string | undefined;
}
export declare const DistributionResourceType: {
  readonly Distribution: "distribution";
  readonly DistributionTenant: "distribution-tenant";
};
export type DistributionResourceType =
  (typeof DistributionResourceType)[keyof typeof DistributionResourceType];
export interface DomainConflict {
  Domain: string | undefined;
  ResourceType: DistributionResourceType | undefined;
  ResourceId: string | undefined;
  AccountId: string | undefined;
}
export interface ListDomainConflictsResult {
  DomainConflicts?: DomainConflict[] | undefined;
  NextMarker?: string | undefined;
}
export interface ListFieldLevelEncryptionConfigsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface FieldLevelEncryptionSummary {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  Comment?: string | undefined;
  QueryArgProfileConfig?: QueryArgProfileConfig | undefined;
  ContentTypeProfileConfig?: ContentTypeProfileConfig | undefined;
}
export interface FieldLevelEncryptionList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: FieldLevelEncryptionSummary[] | undefined;
}
export interface ListFieldLevelEncryptionConfigsResult {
  FieldLevelEncryptionList?: FieldLevelEncryptionList | undefined;
}
export interface ListFieldLevelEncryptionProfilesRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface FieldLevelEncryptionProfileSummary {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  Name: string | undefined;
  EncryptionEntities: EncryptionEntities | undefined;
  Comment?: string | undefined;
}
export interface FieldLevelEncryptionProfileList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: FieldLevelEncryptionProfileSummary[] | undefined;
}
export interface ListFieldLevelEncryptionProfilesResult {
  FieldLevelEncryptionProfileList?: FieldLevelEncryptionProfileList | undefined;
}
export interface ListFunctionsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  Stage?: FunctionStage | undefined;
}
export interface FunctionList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: FunctionSummary[] | undefined;
}
export interface ListFunctionsResult {
  FunctionList?: FunctionList | undefined;
}
export interface ListInvalidationsRequest {
  DistributionId: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface InvalidationSummary {
  Id: string | undefined;
  CreateTime: Date | undefined;
  Status: string | undefined;
}
export interface InvalidationList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: InvalidationSummary[] | undefined;
}
export interface ListInvalidationsResult {
  InvalidationList?: InvalidationList | undefined;
}
export interface ListInvalidationsForDistributionTenantRequest {
  Id: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListInvalidationsForDistributionTenantResult {
  InvalidationList?: InvalidationList | undefined;
}
export interface ListKeyGroupsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface KeyGroupSummary {
  KeyGroup: KeyGroup | undefined;
}
export interface KeyGroupList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: KeyGroupSummary[] | undefined;
}
export interface ListKeyGroupsResult {
  KeyGroupList?: KeyGroupList | undefined;
}
export interface ListKeyValueStoresRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  Status?: string | undefined;
}
export interface KeyValueStoreList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: KeyValueStore[] | undefined;
}
export interface ListKeyValueStoresResult {
  KeyValueStoreList?: KeyValueStoreList | undefined;
}
export interface ListOriginAccessControlsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface OriginAccessControlSummary {
  Id: string | undefined;
  Description: string | undefined;
  Name: string | undefined;
  SigningProtocol: OriginAccessControlSigningProtocols | undefined;
  SigningBehavior: OriginAccessControlSigningBehaviors | undefined;
  OriginAccessControlOriginType: OriginAccessControlOriginTypes | undefined;
}
export interface OriginAccessControlList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: OriginAccessControlSummary[] | undefined;
}
export interface ListOriginAccessControlsResult {
  OriginAccessControlList?: OriginAccessControlList | undefined;
}
export declare const OriginRequestPolicyType: {
  readonly custom: "custom";
  readonly managed: "managed";
};
export type OriginRequestPolicyType =
  (typeof OriginRequestPolicyType)[keyof typeof OriginRequestPolicyType];
export interface ListOriginRequestPoliciesRequest {
  Type?: OriginRequestPolicyType | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface OriginRequestPolicySummary {
  Type: OriginRequestPolicyType | undefined;
  OriginRequestPolicy: OriginRequestPolicy | undefined;
}
export interface OriginRequestPolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: OriginRequestPolicySummary[] | undefined;
}
export interface ListOriginRequestPoliciesResult {
  OriginRequestPolicyList?: OriginRequestPolicyList | undefined;
}
export interface ListPublicKeysRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface PublicKeySummary {
  Id: string | undefined;
  Name: string | undefined;
  CreatedTime: Date | undefined;
  EncodedKey: string | undefined;
  Comment?: string | undefined;
}
export interface PublicKeyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: PublicKeySummary[] | undefined;
}
export interface ListPublicKeysResult {
  PublicKeyList?: PublicKeyList | undefined;
}
export interface ListRealtimeLogConfigsRequest {
  MaxItems?: number | undefined;
  Marker?: string | undefined;
}
export interface RealtimeLogConfigs {
  MaxItems: number | undefined;
  Items?: RealtimeLogConfig[] | undefined;
  IsTruncated: boolean | undefined;
  Marker: string | undefined;
  NextMarker?: string | undefined;
}
export declare const GetDistributionResultFilterSensitiveLog: (
  obj: GetDistributionResult
) => any;
export declare const GetDistributionConfigResultFilterSensitiveLog: (
  obj: GetDistributionConfigResult
) => any;
export declare const GetFunctionResultFilterSensitiveLog: (
  obj: GetFunctionResult
) => any;
export declare const DistributionSummaryFilterSensitiveLog: (
  obj: DistributionSummary
) => any;
export declare const DistributionListFilterSensitiveLog: (
  obj: DistributionList
) => any;
export declare const ListDistributionsResultFilterSensitiveLog: (
  obj: ListDistributionsResult
) => any;
export declare const ListDistributionsByAnycastIpListIdResultFilterSensitiveLog: (
  obj: ListDistributionsByAnycastIpListIdResult
) => any;
export declare const ListDistributionsByConnectionModeResultFilterSensitiveLog: (
  obj: ListDistributionsByConnectionModeResult
) => any;
export declare const ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog: (
  obj: ListDistributionsByRealtimeLogConfigResult
) => any;
export declare const ListDistributionsByWebACLIdResultFilterSensitiveLog: (
  obj: ListDistributionsByWebACLIdResult
) => any;
