"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const e = exposes.presets;
exports.definitions = [
    {
        zigbeeModel: ["ZG_LED_DRIVER42CC"],
        model: "ZG_LED_DRIVER42CC",
        vendor: "Envilar",
        description: "Zigbee LED driver",
        extend: [m.light()],
    },
    {
        zigbeeModel: ["ZG50CC-CCT-DRIVER", "HK-CCT"],
        model: "ZG50CC-CCT-DRIVER",
        vendor: "Envilar",
        description: "Zigbee CCT LED driver",
        extend: [m.light({ colorTemp: { range: [160, 450] } })],
    },
    {
        zigbeeModel: ["ZGR904-S"],
        model: "ZGR904-S",
        vendor: "Envilar",
        description: "Touchlink remote",
        meta: { battery: { dontDividePercentage: true } },
        fromZigbee: [fz.command_recall, fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        toZigbee: [],
        exposes: [e.battery(), e.action(["recall_1", "recall_2", "on", "off", "brightness_stop", "brightness_move_up", "brightness_move_down"])],
    },
    {
        zigbeeModel: ["ZG102-BOX-UNIDIM"],
        model: "ZG102-BOX-UNIDIM",
        vendor: "Envilar",
        description: "Zigbee AC phase-cut dimmer",
        extend: [m.light({ configureReporting: true })],
    },
    {
        zigbeeModel: ["ZG302-BOX-RELAY"],
        model: "ZG302-BOX-RELAY",
        vendor: "Envilar",
        description: "Zigbee AC in wall switch",
        extend: [m.onOff()],
    },
    {
        zigbeeModel: ["2CH-ZG-BOX-RELAY"],
        model: "2CH-ZG-BOX-RELAY",
        vendor: "Envilar",
        description: "2 channel box relay",
        extend: [m.deviceEndpoints({ endpoints: { l1: 1, l2: 2 } }), m.onOff({ endpointNames: ["l1", "l2"] })],
    },
    {
        zigbeeModel: ["7853"],
        model: "1CH-HP-RELAY-7853",
        vendor: "Envilar",
        description: "1 channel high power box relay",
        extend: [m.onOff({ powerOnBehavior: true }), m.identify(), m.electricityMeter()],
        whiteLabel: [{ vendor: "Sunricher", model: "SR-ZG9101SAC-HP-SWITCH-B" }],
    },
    {
        zigbeeModel: ["7848"],
        model: "7848",
        vendor: "Envilar",
        description: "Dimmable LED driver",
        extend: [m.light()],
    },
    {
        zigbeeModel: ["5480"],
        model: "5480",
        vendor: "Envilar",
        description: "Zigbee CV dimmable LED driver",
        extend: [m.light()],
    },
    {
        zigbeeModel: ["5463"],
        model: "5463",
        vendor: "Envilar",
        description: "Zigbee CCT dimmable LED driver",
        extend: [m.light({ colorTemp: { range: [160, 450] } }), m.identify()],
    },
];
//# sourceMappingURL=envilar.js.map