/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.model.pipeline;

import com.jetbrains.mlapi.model.pipeline.VFSNode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/mlapi/model/pipeline/ActualFile;", "Lcom/jetbrains/mlapi/model/pipeline/VFSNode$File;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "content", "", "getContent", "()[B", "toString", "", "mlapi-core"})
final class ActualFile
extends VFSNode.File {
    @NotNull
    private final Path path;

    public ActualFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(PathsKt.getName((Path)path));
        this.path = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-ActualFile$32 = false;
            String $i$a$-require-ActualFile$32 = "File " + this.path + " does not exist";
            throw new IllegalArgumentException($i$a$-require-ActualFile$32.toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(this.path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            boolean bl = false;
            String string = "Path " + this.path + " was expected to be a file, but it is not";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public byte[] getContent() {
        byte[] byArray = Files.readAllBytes(this.path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return this.getName() + "(size=" + this.getContent().length + ")";
    }
}

