/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkUnaryMinusImageFilter_h
#define sitkUnaryMinusImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class UnaryMinusImageFilter
\brief Implements pixel-wise generic operation on one image.

This class is parameterized over the type of the input image and the type of the output image. It is also parameterized by the operation to be applied, using a Functor style.

UnaryFunctorImageFilter allows the output dimension of the filter to be larger than the input dimension. Thus subclasses of the UnaryFunctorImageFilter (like the CastImageFilter ) can be used to promote a 2D image to a 3D image, etc.

\see UnaryGeneratorImageFilter 


\see BinaryFunctorImageFilter TernaryFunctorImageFilter
\sa itk::simple::UnaryMinus for the procedural interface
\sa itk::UnaryFunctorImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT UnaryMinusImageFilter : public ImageFilter {
    public:
      using Self = UnaryMinusImageFilter;

      /** Destructor */
      virtual ~UnaryMinusImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      UnaryMinusImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = typelist2::append< SignedPixelIDTypeList, ComplexPixelIDTypeList >::type;


      /** Name of this class */
      std::string GetName() const { return std::string ("UnaryMinusImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInternal on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      bool m_InPlace{false};
    };

    /**\
     * \brief Implements pixel-wise generic operation on one image.
     *
     * This function directly calls the execute method of UnaryMinusImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::UnaryMinusImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image UnaryMinus ( Image&& image1 );
#endif
     SITKBasicFilters_EXPORT Image UnaryMinus ( const Image& image1 );

     /** @} */
}
#endif
