#pragma once

#include "esphome/core/component.h"
#include "esphome/components/i2c/i2c.h"

namespace esphome {
namespace tca9548a {

static const uint8_t TCA9548A_DISABLE_CHANNELS_COMMAND = 0x00;

class TCA9548AComponent;
class TCA9548AChannel : public i2c::I2CBus {
 public:
  void set_channel(uint8_t channel) { channel_ = channel; }
  void set_parent(TCA9548AComponent *parent) { parent_ = parent; }

  i2c::ErrorCode write_readv(uint8_t address, const uint8_t *write_buffer, size_t write_count, uint8_t *read_buffer,
                             size_t read_count) override;

 protected:
  uint8_t channel_;
  TCA9548AComponent *parent_;
};

class TCA9548AComponent : public Component, public i2c::I2CDevice {
 public:
  void setup() override;
  void dump_config() override;
  float get_setup_priority() const override { return setup_priority::IO; }
  void update();

  i2c::ErrorCode switch_to_channel(uint8_t channel);
  void disable_all_channels();

 protected:
  friend class TCA9548AChannel;
};
}  // namespace tca9548a
}  // namespace esphome
