/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutError;
import org.jetbrains.kotlin.ir.interpreter.proxy.CommonProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00de\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u001c*\u00020 H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%J0\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0019\u0010)\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010*\u00a2\u0006\u0002\b+H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002J\f\u00100\u001a\u00020\u001c*\u000201H\u0002J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u0007H\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020^H\u0002J\u0010\u0010_\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020`H\u0002J\u0010\u0010a\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020dH\u0002J\u0010\u0010e\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020fH\u0002J\u0010\u0010g\u001a\u00020\u001c2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020kH\u0002J\u0010\u0010l\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020mH\u0002J\u0010\u0010n\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020oH\u0002J\u0010\u0010p\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020sH\u0002J\u0010\u0010t\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020uH\u0002J\u0010\u0010v\u001a\u00020\u001c2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020\u001c2\u0006\u0010z\u001a\u00020{H\u0002J\u0010\u0010|\u001a\u00020\u001c2\u0006\u0010}\u001a\u00020~H\u0002J\u0011\u0010\u007f\u001a\u00020\u001c2\u0007\u0010#\u001a\u00030\u0080\u0001H\u0002J\u0012\u0010\u0081\u0001\u001a\u00020\u001c2\u0007\u0010w\u001a\u00030\u0082\u0001H\u0002J\u0012\u0010\u0083\u0001\u001a\u00020\u001c2\u0007\u0010w\u001a\u00030\u0084\u0001H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;Ljava/util/Map;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Map;)V", "getEnvironment$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getBodyMap$ir_interpreter", "()Ljava/util/Map;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "commandCount", "", "incrementAndCheckCommands", "", "getUnitState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "handle", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "interpret", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "withNewCallStack", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withNewCallStack$ir_interpreter", "extractResultAndAssertThatStackIsEmpty", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "tryResetFunctionBody", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "interpretFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "interpretCall", "interpretField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "interpretBody", "body", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "interpretConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretVariable", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "interpretSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretWhile", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "interpretDoWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretWhen", "whenExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "interpretBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "interpretClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "interpretGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "interpretRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "interpretRichPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreter.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ExceptionUtils.kt\norg/jetbrains/kotlin/ir/interpreter/exceptions/ExceptionUtilsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,642:1\n1#2:643\n1586#3:644\n1661#3,3:645\n1924#3,3:648\n1586#3:653\n1661#3,3:654\n1924#3,3:657\n812#3,12:662\n231#3,2:674\n1391#3:694\n1480#3,5:695\n812#3,12:700\n231#3,2:712\n1586#3:714\n1661#3,3:715\n1586#3:718\n1661#3,3:719\n1586#3:722\n1661#3,3:723\n1586#3:726\n1661#3,3:727\n1586#3:730\n1661#3,3:731\n812#3,12:734\n1915#3,2:746\n221#4,2:651\n20#5,2:660\n17#6,16:676\n33#6:693\n19#7:692\n*S KotlinDebug\n*F\n+ 1 IrInterpreter.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreter\n*L\n167#1:644\n167#1:645,3\n186#1:648,3\n224#1:653\n224#1:654,3\n247#1:657,3\n471#1:662,12\n472#1:674,2\n506#1:694\n506#1:695,5\n524#1:700,12\n524#1:712,2\n525#1:714\n525#1:715,3\n579#1:718\n579#1:719,3\n590#1:722\n590#1:723,3\n626#1:726\n626#1:727,3\n637#1:730\n637#1:731,3\n410#1:734,12\n594#1:746,2\n191#1:651,2\n370#1:660,2\n475#1:676,16\n475#1:693\n475#1:692\n*E\n"})
public final class IrInterpreter {
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final CallInterceptor callInterceptor;
    private int commandCount;

    public IrInterpreter(@NotNull IrInterpreterEnvironment environment, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this.environment = environment;
        this.bodyMap = bodyMap;
        this.callInterceptor = new DefaultCallInterceptor(this);
    }

    public /* synthetic */ IrInterpreter(IrInterpreterEnvironment irInterpreterEnvironment, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irInterpreterEnvironment, (Map<IdSignature, ? extends IrBody>)map);
    }

    @NotNull
    public final IrInterpreterEnvironment getEnvironment$ir_interpreter() {
        return this.environment;
    }

    @NotNull
    public final Map<IdSignature, IrBody> getBodyMap$ir_interpreter() {
        return this.bodyMap;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.environment.getIrBuiltIns();
    }

    private final CallStack getCallStack() {
        return this.environment.getCallStack$ir_interpreter();
    }

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this(new IrInterpreterEnvironment(irBuiltIns, null, 2, null), bodyMap);
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irBuiltIns, (Map<IdSignature, ? extends IrBody>)map);
    }

    private final void incrementAndCheckCommands() {
        int n = this.commandCount;
        this.commandCount = n + 1;
        if (this.commandCount >= this.environment.getConfiguration().getMaxCommands()) {
            ExceptionUtilsKt.handleUserException(new InterpreterTimeOutError(), this.environment);
        }
    }

    private final State getUnitState() {
        Complex complex = this.environment.getMapOfObjects$ir_interpreter().get(this.getIrBuiltIns().getUnitClass());
        Intrinsics.checkNotNull((Object)complex);
        return complex;
    }

    private final void handle(Instruction $this$handle) {
        Instruction instruction = $this$handle;
        if (instruction instanceof CompoundInstruction) {
            InstructionsUnfolderKt.unfoldInstruction(((CompoundInstruction)$this$handle).getElement(), this.environment);
        } else if (instruction instanceof SimpleInstruction) {
            Unit unit;
            this.interpret(((SimpleInstruction)$this$handle).getElement());
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.incrementAndCheckCommands();
        } else if (instruction instanceof CustomInstruction) {
            ((CustomInstruction)$this$handle).getEvaluate().invoke();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression, @Nullable IrFile file) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.commandCount = 0;
        this.getCallStack().newFrame(expression, file);
        InstructionKt.pushCompoundInstruction(this.getCallStack(), expression);
        while (!this.getCallStack().hasNoInstructions()) {
            this.handle(this.getCallStack().popInstruction());
        }
        return this.environment.stateToIrExpression$ir_interpreter(this.extractResultAndAssertThatStackIsEmpty(), expression);
    }

    public static /* synthetic */ IrExpression interpret$default(IrInterpreter irInterpreter, IrExpression irExpression, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        return irInterpreter.interpret(irExpression, irFile);
    }

    @NotNull
    public final State withNewCallStack$ir_interpreter(@NotNull IrCall call, @NotNull Function1<? super IrInterpreter, ? extends Object> init) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        IrInterpreter $this$withNewCallStack_u24lambda_u240 = new IrInterpreter(this.environment.copyWithNewCallStack(), this.bodyMap);
        boolean bl = false;
        $this$withNewCallStack_u24lambda_u240.getCallStack().newFrame(call.getSymbol().getOwner());
        init.invoke((Object)$this$withNewCallStack_u24lambda_u240);
        while (!$this$withNewCallStack_u24lambda_u240.getCallStack().hasNoInstructions()) {
            $this$withNewCallStack_u24lambda_u240.handle($this$withNewCallStack_u24lambda_u240.getCallStack().popInstruction());
        }
        return $this$withNewCallStack_u24lambda_u240.extractResultAndAssertThatStackIsEmpty();
    }

    private final State extractResultAndAssertThatStackIsEmpty() {
        boolean bl;
        State result = this.getCallStack().popState();
        boolean bl2 = bl = this.getCallStack().peekState() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.getCallStack().dropFrame();
        return result;
    }

    private final void interpret(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrSimpleFunction) {
            this.interpretFunction((IrSimpleFunction)element);
        } else if (irElement instanceof IrConstructor) {
            this.interpretConstructor((IrConstructor)element);
        } else if (irElement instanceof IrCall) {
            this.interpretCall((IrCall)element);
        } else if (irElement instanceof IrConstructorCall) {
            this.interpretConstructorCall((IrFunctionAccessExpression)element);
        } else if (irElement instanceof IrEnumConstructorCall) {
            this.interpretEnumConstructorCall((IrEnumConstructorCall)element);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            this.interpretDelegatingConstructorCall((IrDelegatingConstructorCall)element);
        } else if (irElement instanceof IrInstanceInitializerCall) {
            this.getCallStack().pushState(this.getUnitState());
        } else if (irElement instanceof IrValueParameter) {
            this.interpretValueParameter((IrValueParameter)element);
        } else if (irElement instanceof IrField) {
            this.interpretField((IrField)element);
        } else if (irElement instanceof IrBody) {
            this.interpretBody((IrBody)element);
        } else if (irElement instanceof IrBlock) {
            this.interpretBlock((IrBlock)element);
        } else if (irElement instanceof IrReturn) {
            this.interpretReturn((IrReturn)element);
        } else if (irElement instanceof IrSetField) {
            this.interpretSetField((IrSetField)element);
        } else if (irElement instanceof IrGetField) {
            this.interpretGetField((IrGetField)element);
        } else if (irElement instanceof IrGetObjectValue) {
            this.interpretGetObjectValue((IrGetObjectValue)element);
        } else if (irElement instanceof IrGetEnumValue) {
            this.interpretGetEnumValue((IrGetEnumValue)element);
        } else if (irElement instanceof IrEnumEntry) {
            this.interpretEnumEntry((IrEnumEntry)element);
        } else if (irElement instanceof IrConst) {
            this.interpretConst((IrConst)element);
        } else if (irElement instanceof IrVariable) {
            this.interpretVariable((IrVariable)element);
        } else if (irElement instanceof IrSetValue) {
            this.interpretSetValue((IrSetValue)element);
        } else if (irElement instanceof IrTypeOperatorCall) {
            this.interpretTypeOperatorCall((IrTypeOperatorCall)element);
        } else if (irElement instanceof IrBranch) {
            this.interpretBranch((IrBranch)element);
        } else if (irElement instanceof IrWhileLoop) {
            this.interpretWhile((IrWhileLoop)element);
        } else if (irElement instanceof IrDoWhileLoop) {
            this.interpretDoWhile((IrDoWhileLoop)element);
        } else if (irElement instanceof IrWhen) {
            this.interpretWhen((IrWhen)element);
        } else if (irElement instanceof IrVararg) {
            this.interpretVararg((IrVararg)element);
        } else if (irElement instanceof IrTry) {
            this.interpretTry((IrTry)element);
        } else if (irElement instanceof IrThrow) {
            this.interpretThrow((IrThrow)element);
        } else if (irElement instanceof IrStringConcatenation) {
            this.interpretStringConcatenation((IrStringConcatenation)element);
        } else if (irElement instanceof IrFunctionExpression) {
            this.interpretFunctionExpression((IrFunctionExpression)element);
        } else if (irElement instanceof IrFunctionReference) {
            this.interpretFunctionReference((IrFunctionReference)element);
        } else if (irElement instanceof IrPropertyReference) {
            this.interpretPropertyReference((IrPropertyReference)element);
        } else if (irElement instanceof IrClassReference) {
            this.interpretClassReference((IrClassReference)element);
        } else if (irElement instanceof IrGetClass) {
            this.interpretGetClass((IrGetClass)element);
        } else if (irElement instanceof IrRichFunctionReference) {
            this.interpretRichFunctionReference((IrRichFunctionReference)element);
        } else if (irElement instanceof IrRichPropertyReference) {
            this.interpretRichPropertyReference((IrRichPropertyReference)element);
        } else {
            String string = element.getClass() + " not supported for interpretation";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    private final void tryResetFunctionBody(IrFunction $this$tryResetFunctionBody) {
        IdSignature idSignature = $this$tryResetFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return;
        }
        IdSignature signature = idSignature;
        if (this.bodyMap.get(signature) != null) {
            $this$tryResetFunctionBody.setBody(null);
        }
    }

    private final void interpretFunction(IrSimpleFunction function) {
        this.tryResetFunctionBody(function);
        if (UtilsKt.checkCast(function, this.environment)) {
            this.getCallStack().dropFrameAndCopyResult();
        }
    }

    private final void interpretValueParameter(IrValueParameter valueParameter) {
        IrDeclarationParent irDeclarationParent = valueParameter.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction irFunction = (IrFunction)irDeclarationParent;
        State state = this.getCallStack().popState();
        if (StateKt.checkNullability(state, valueParameter.getType(), this.environment, (Function0<? extends Throwable>)((Function0)() -> IrInterpreter.interpretValueParameter$lambda$0(valueParameter, irFunction))) == null) {
            return;
        }
        this.getCallStack().pushState(state);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretCall(IrCall call) {
        State dispatchReceiver;
        Object object;
        State state;
        void $this$mapTo$iv$iv;
        IrSimpleFunction owner = (IrSimpleFunction)call.getSymbol().getOwner();
        Iterable $this$map$iv = IrUtilsKt.getNonDispatchParameters(owner);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List nonDispatchArguments = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        IrValueParameter irValueParameter = owner.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        if ((object = (dispatchReceiver = state)) == null || (object = object.getIrFunctionByIrCall(call)) == null) {
            object = call.getSymbol().getOwner();
        }
        Object irFunction = object;
        List args = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)IrInterpreter.interpretCall$getThisOrSuperReceiver(dispatchReceiver, (IrFunction)irFunction)), (Iterable)nonDispatchArguments);
        Map<IrTypeParameterSymbol, KTypeState> reifiedTypeArguments = UtilsKt.loadReifiedTypeArguments(this.environment, call);
        this.getCallStack().newFrame((IrFunction)irFunction);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), (IrElement)irFunction);
        if (dispatchReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)dispatchReceiver));
        }
        if (AdditionalIrUtilsKt.isLocal((IrDeclaration)irFunction)) {
            this.getCallStack().copyUpValuesFromPreviousFrame();
        }
        IrValueParameter irValueParameter2 = ((IrFunction)irFunction).getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            IrValueParameter it = irValueParameter2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it.getSymbol(), dispatchReceiver);
        }
        Iterable $this$forEachIndexed$iv = IrUtilsKt.getNonDispatchParameters((IrFunction)irFunction);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)nonDispatchArguments.get(i));
        }
        this.getCallStack().storeState((IrSymbol)((IrFunction)irFunction).getSymbol(), new KTypeState(call.getType(), (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Map<IrTypeParameterSymbol, KTypeState> $this$forEach$iv = reifiedTypeArguments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrTypeParameterSymbol, KTypeState>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IrTypeParameterSymbol, KTypeState> element$iv;
            Map.Entry<IrTypeParameterSymbol, KTypeState> it = element$iv = iterator.next();
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it.getKey(), it.getValue());
        }
        if (dispatchReceiver instanceof Complex) {
            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)irFunction);
            boolean bl = irClass != null ? irClass.isInner() : false;
            if (bl) {
                Complex.loadOuterClassesInto$default((Complex)dispatchReceiver, this.getCallStack(), null, 2, null);
            }
        }
        this.callInterceptor.interceptCall(call, (IrFunction)irFunction, args, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretCall$lambda$5(this, (IrFunction)irFunction)));
    }

    private final void interpretField(IrField field) {
        IrClass irClass = IrUtilsKt.getParentAsClass(field);
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol receiver = irValueParameter.getSymbol();
        State receiverState = this.getCallStack().loadState(receiver);
        IrPropertySymbol irPropertySymbol = field.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        receiverState.setField(irPropertySymbol, this.getCallStack().popState());
    }

    private final void interpretBody(IrBody body) {
        if (IrUtilsKt.getStatements(body).isEmpty()) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretBlock(IrBlock block) {
        this.getCallStack().dropSubFrame();
        if (block.getStatements().isEmpty()) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretConstructor(IrConstructor constructor) {
        CallStack callStack = this.getCallStack();
        CallStack callStack2 = this.getCallStack();
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        callStack.pushState(callStack2.loadState(irValueParameter.getSymbol()));
        this.getCallStack().dropFrameAndCopyResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretConstructorCall(IrFunctionAccessExpression constructorCall) {
        IrValueSymbol superReceiver;
        IrValueSymbol irValueSymbol;
        IrStatement irStatement;
        State state;
        State objectState;
        State state2;
        IrValueParameterSymbol receiverSymbol;
        void $this$mapTo$iv$iv;
        IrFunction constructor = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        Iterable $this$map$iv = IrUtilsKt.getNonDispatchParameters(constructor);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List nonDispatchArguments = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        IrClass irClass = IrUtilsKt.getParentAsClass(constructor);
        IrValueParameter irValueParameter = constructor.getDispatchReceiverParameter();
        IrValueParameterSymbol irValueParameterSymbol = receiverSymbol = irValueParameter != null ? irValueParameter.getSymbol() : null;
        if (!(constructorCall instanceof IrConstructorCall)) {
            state2 = this.getCallStack().loadState(UtilsKt.getThisReceiver(constructorCall));
        } else {
            StateWithClosure $this$interpretConstructorCall_u24lambda_u241 = $i$f$mapTo = UtilsKt.isSubclassOfThrowable(irClass) ? new ExceptionState(irClass, this.environment) : new Common(irClass);
            boolean bl = false;
            if (IrUtilsKt.isObject(irClass)) {
                this.environment.getMapOfObjects$ir_interpreter().put(irClass.getSymbol(), (Complex)((Object)$this$interpretConstructorCall_u24lambda_u241));
            }
            state2 = objectState = (State)((Object)$i$f$mapTo);
        }
        if (AdditionalIrUtilsKt.isLocal(irClass)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.storeUpValues((StateWithClosure)((Object)objectState));
        }
        IrValueParameterSymbol irValueParameterSymbol2 = receiverSymbol;
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it = irValueParameterSymbol2;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        State outerClass = state;
        IrType returnType = UtilsKt.getTypeIfReified(constructorCall.getType(), this.getCallStack());
        this.getCallStack().newFrame(constructor);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), constructor);
        if (AdditionalIrUtilsKt.isLocal(irClass)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.loadUpValues((StateWithClosure)((Object)objectState));
        }
        this.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(constructorCall), objectState);
        Iterable $this$forEachIndexed$iv = IrUtilsKt.getNonDispatchParameters(constructor);
        boolean $i$f$forEachIndexed = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)nonDispatchArguments.get(i));
        }
        this.getCallStack().storeState((IrSymbol)constructor.getSymbol(), new KTypeState(returnType, (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Object object = constructor.getBody();
        IrStatement irStatement2 = object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null ? (IrStatement)CollectionsKt.getOrNull((List)object, (int)0) : (irStatement = null);
        if (irStatement == null) {
            irValueSymbol = null;
        } else if (irStatement instanceof IrTypeOperatorCall) {
            IrExpression irExpression = ((IrTypeOperatorCall)irStatement).getArgument();
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irExpression);
        } else if (irStatement instanceof IrFunctionAccessExpression) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement);
        } else if (irStatement instanceof IrBlock) {
            Object object2 = CollectionsKt.last(((IrBlock)irStatement).getStatements());
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)object2);
        } else {
            String index$iv2 = irStatement.getClass() + " is not supported as first statement in constructor call";
            throw new NotImplementedError("An operation is not implemented: " + index$iv2);
        }
        IrValueSymbol irValueSymbol2 = superReceiver = irValueSymbol;
        if (irValueSymbol2 != null) {
            IrValueSymbol it = irValueSymbol2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, objectState);
        }
        if (outerClass != null) {
            IrValueParameter irValueParameter3 = IrUtilsKt.getParentAsClass(irClass).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter3);
            Pair outerClassSymbolToState = TuplesKt.to((Object)irValueParameter3.getSymbol(), (Object)outerClass);
            Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            ((Complex)objectState).setOuterClass((Pair<? extends IrSymbol, ? extends State>)outerClassSymbolToState);
            Object object3 = superReceiver;
            if (!Intrinsics.areEqual((Object)(object3 != null && (object3 = object3.getOwner()) != null ? object3.getType() : null), (Object)((IrValueParameter)receiverSymbol.getOwner()).getType())) {
                this.getCallStack().storeState((IrSymbol)receiverSymbol, outerClass);
                ((Complex)objectState).loadOuterClassesInto(this.getCallStack(), UtilsKt.getThisReceiver(constructorCall));
            }
        }
        this.callInterceptor.interceptConstructor(constructorCall, nonDispatchArguments, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretConstructorCall$lambda$5(this, constructor)));
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretDelegatingConstructorCall(IrDelegatingConstructorCall constructorCall) {
        if (Intrinsics.areEqual((Object)((IrConstructor)constructorCall.getSymbol().getOwner()).getParent(), (Object)this.getIrBuiltIns().getAnyClass().getOwner())) {
            return;
        }
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretEnumConstructorCall(IrEnumConstructorCall constructorCall) {
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretConst(IrConst expression) {
        this.getCallStack().pushState(UtilsKt.toPrimitive(expression));
    }

    private final void interpretVariable(IrVariable variable) {
        this.getCallStack().storeState((IrSymbol)variable.getSymbol(), this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretSetValue(IrSetValue expression) {
        this.getCallStack().rewriteState(expression.getSymbol(), this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretReturn(IrReturn expression) {
        this.getCallStack().returnFromFrameWithResult(expression);
    }

    private final void interpretWhile(IrWhileLoop loop) {
        boolean result = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result) {
            this.getCallStack().newSubFrame(loop);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getBody());
        }
    }

    private final void interpretDoWhile(IrDoWhileLoop loop) {
        boolean result = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result) {
            this.getCallStack().newSubFrame(loop);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getBody());
        }
    }

    private final void interpretWhen(IrWhen whenExpression) {
        this.getCallStack().dropSubFrame();
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretBranch(IrBranch branch) {
        boolean result = StateKt.asBoolean(this.getCallStack().popState());
        if (result) {
            this.getCallStack().dropSubFrame();
            InstructionKt.pushCompoundInstruction(this.getCallStack(), branch.getResult());
        }
    }

    private final void interpretSetField(IrSetField expression) {
        State state;
        IrExpression irExpression = expression.getReceiver();
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        IrSymbol receiver = ((IrDeclarationReference)irExpression).getSymbol();
        IrPropertySymbol irPropertySymbol = ((IrField)expression.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrPropertySymbol propertySymbol = irPropertySymbol;
        State $this$interpretSetField_u24lambda_u240 = state = this.getCallStack().loadState(receiver);
        boolean bl = false;
        $this$interpretSetField_u24lambda_u240.setField(propertySymbol, this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void interpretGetField(IrGetField expression) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var4_2 = expression.getReceiver();
                        v0 = var4_2 instanceof IrDeclarationReference != false ? (IrDeclarationReference)var4_2 : null;
                        receiver = v0 != null ? v0.getSymbol() : null;
                        field = (IrField)expression.getSymbol().getOwner();
                        if (!Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || !field.isStatic()) break block5;
                        v1 = field.getInitializer();
                        v2 = initializerExpression = v1 != null ? v1.getExpression() : null;
                        if (initializerExpression instanceof IrConst) {
                            InstructionKt.pushSimpleInstruction(this.getCallStack(), initializerExpression);
                        } else {
                            this.callInterceptor.interceptJavaStaticField(expression);
                        }
                        break block6;
                    }
                    if (!Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_BACKING_FIELD()) || !UtilsKt.isConst(UtilsKt.getProperty(field))) break block7;
                    v3 = field.getInitializer();
                    InstructionKt.pushCompoundInstruction(this.getCallStack(), v3 != null ? v3.getExpression() : null);
                    break block6;
                }
                if (!UtilsKt.accessesTopLevelOrObjectField(expression)) break block8;
                propertyOwner = UtilsKt.getProperty(field);
                if (UtilsKt.isConst(propertyOwner) || ((v4 = propertyOwner) != null && (v4 = v4.getBackingField()) != null && (v4 = v4.getInitializer()) != null ? v4.getExpression() : null) instanceof IrConst) ** GOTO lbl-1000
                v5 /* !! */  = propertyOwner;
                v6 = v5 /* !! */  != null && (v5 /* !! */  = IrUtilsKt.getParentClassOrNull(v5 /* !! */ )) != null ? UtilsKt.hasAnnotation(v5 /* !! */ , UtilsKt.getCompileTimeAnnotation()) : false;
                if (v6) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else {
                    v7 = false;
                }
                value$iv = isConst = v7;
                $i$f$verify = false;
                if (!value$iv) {
                    $i$a$-verify-IrInterpreter$interpretGetField$1 = false;
                    var9_9 = "Cannot interpret get method on top level non const properties".toString();
                    throw new InterpreterAssertionError(var9_9);
                }
                v8 = field.getInitializer();
                InstructionKt.pushCompoundInstruction(this.getCallStack(), v8 != null ? v8.getExpression() : null);
                break block6;
            }
            v9 = this.getCallStack();
            v10 = receiver;
            Intrinsics.checkNotNull((Object)v10);
            v11 = v9.loadState(v10);
            v12 = field.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull((Object)v12);
            result = v11.getField(v12);
            v13 = this.getCallStack();
            v14 = result;
            Intrinsics.checkNotNull((Object)v14);
            v13.pushState(v14);
        }
    }

    private final void interpretGetObjectValue(IrGetObjectValue expression) {
        this.callInterceptor.interceptGetObjectValue(expression, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretGetObjectValue$lambda$0(expression, this)));
    }

    private final void interpretGetEnumValue(IrGetEnumValue expression) {
        CallStack callStack = this.getCallStack();
        Complex complex = this.environment.getMapOfEnums$ir_interpreter().get(expression.getSymbol());
        Intrinsics.checkNotNull((Object)complex);
        callStack.pushState(complex);
    }

    private final void interpretEnumEntry(IrEnumEntry enumEntry) {
        this.callInterceptor.interceptEnumEntry(enumEntry, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretEnumEntry$lambda$0(enumEntry, this)));
    }

    /*
     * Unable to fully structure code
     */
    private final void interpretTypeOperatorCall(IrTypeOperatorCall expression) {
        typeClassifier = IrTypesKt.getClassifierOrFail(expression.getTypeOperand());
        var5_3 = typeClassifier.getOwner();
        v0 = var5_3 instanceof IrTypeParameter != false ? (IrTypeParameter)var5_3 : null;
        isReified = v0 != null ? v0.isReified() : false;
        isErased = typeClassifier.getOwner() instanceof IrTypeParameter != false && isReified == false;
        typeOperand = UtilsKt.getTypeIfReified(expression.getTypeOperand(), this.getCallStack());
        state = this.getCallStack().popState();
        switch (WhenMappings.$EnumSwitchMapping$0[expression.getOperator().ordinal()]) {
            case 1: {
                this.getCallStack().pushState(this.getUnitState());
                break;
            }
            case 2: 
            case 3: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    break;
                }
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    castedClassName = UtilsKt.getFqName(state.getIrClass());
                    ExceptionUtilsKt.handleUserException(new ClassCastException(castedClassName + " cannot be cast to " + RenderIrElementKt.render$default(typeOperand, null, 1, null)), this.environment);
                    break;
                }
                this.getCallStack().pushState(state);
                break;
            }
            case 4: {
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(null, this.getIrBuiltIns().getNothingNType()));
                    break;
                }
                this.getCallStack().pushState(state);
                break;
            }
            case 5: {
                isInstance = isErased != false || StateKt.isSubtypeOf(state, typeOperand) != false;
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance, this.getIrBuiltIns().getBooleanType()));
                break;
            }
            case 6: {
                isInstance = isErased != false || StateKt.isSubtypeOf(state, typeOperand) != false;
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance == false, this.getIrBuiltIns().getBooleanType()));
                break;
            }
            case 7: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    break;
                }
                this.getCallStack().pushState(state);
                break;
            }
            case 8: {
                if (!StateKt.isNull(state)) ** GOTO lbl50
                v1 = state;
                ** GOTO lbl111
lbl50:
                // 1 sources

                if (!(state instanceof KFunctionState)) ** GOTO lbl57
                var8_11 = state;
                $this$interpretTypeOperatorCall_u24lambda_u240 = (KFunctionState)var8_11;
                $i$a$-apply-IrInterpreter$interpretTypeOperatorCall$newState$1 = false;
                $this$interpretTypeOperatorCall_u24lambda_u240.setFunInterface(typeOperand);
                v1 = var8_11;
                ** GOTO lbl111
lbl57:
                // 1 sources

                v2 = IrTypesKt.getClassOrNull(typeOperand);
                Intrinsics.checkNotNull((Object)v2);
                samClass = (IrClass)v2.getOwner();
                samFunction = UtilsKt.getSingleAbstractMethod(samClass);
                $this$filterIsInstance$iv = state.getIrClass().getDeclarations();
                $i$f$filterIsInstance = false;
                var13_18 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                var16_23 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (var16_23.hasNext()) {
                    element$iv$iv = var16_23.next();
                    if (!(element$iv$iv instanceof IrFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (IrFunction)element$iv;
                    $i$a$-first-IrInterpreter$interpretTypeOperatorCall$newState$invokeFunction$1 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.INVOKE) != false && it.getParameters().size() == samFunction.getParameters().size())) continue;
                    ** GOTO lbl82
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl82:
                // 1 sources

                invokeFunction = (IrFunction)element$iv;
                functionClass = IrUtilsKt.getParentAsClass(UtilsKt.getLastOverridden(invokeFunction));
                $this$filterIsInstanceTo$iv$iv = invokeFunction;
                initialParent$iv = samClass;
                $i$f$deepCopyWithSymbols = false;
                $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                $i$f$deepCopyImpl = false;
                symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                var20_30 = symbolRemapper$iv$iv;
                $i$a$-deepCopyWithSymbols-DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1 = false;
                p0 = var20_30;
                typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                v3 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                if (v3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                newInvoke = (IrFunction)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrFunction)v3), initialParent$iv);
                newInvoke.setParameters(IrUtilsKt.getNonDispatchParameters(newInvoke));
                $this$interpretTypeOperatorCall_u24lambda_u242 = var13_18 = new KFunctionState(newInvoke, functionClass, this.environment, null, 8, null);
                $i$a$-apply-IrInterpreter$interpretTypeOperatorCall$newState$2 = false;
                $this$interpretTypeOperatorCall_u24lambda_u242.setFunInterface(typeOperand);
                v4 = invokeFunction.getDispatchReceiverParameter();
                if (v4 != null && (v4 = v4.getSymbol()) != null) {
                    it = v4;
                    $i$a$-let-IrInterpreter$interpretTypeOperatorCall$newState$2$1 = false;
                    $this$interpretTypeOperatorCall_u24lambda_u242.getUpValues().put((IrSymbol)it, new Variable(state));
                }
                v1 = (State)var13_18;
lbl111:
                // 3 sources

                newState = v1;
                this.getCallStack().pushState(newState);
                break;
            }
            default: {
                ExceptionUtilsKt.stop((Function0<? extends Object>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, interpretTypeOperatorCall$lambda$3(org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall ), ()Ljava/lang/Object;)((IrTypeOperatorCall)expression));
                throw new KotlinNothingValueException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretVararg(IrVararg expression) {
        State state;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = expression.getElements();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Object> list;
            IrVarargElement it = (IrVarargElement)element$iv$iv;
            boolean bl = false;
            State result = this.getCallStack().popState();
            if (result instanceof Wrapper) {
                list = CollectionsKt.listOf((Object)((Wrapper)result).getValue());
            } else if (result instanceof Primitive) {
                list = IrTypePredicatesKt.isArray(expression.getVarargElementType()) || UtilsKt.isPrimitiveArray(expression.getVarargElementType()) ? CollectionsKt.listOf((Object)result) : IrInterpreter.interpretVararg$arrayToList(((Primitive)result).getValue());
            } else if (result instanceof Common) {
                if (UtilsKt.isUnsignedArray(IrUtilsKt.getDefaultType(((Common)result).getIrClass()))) {
                    Object object = CollectionsKt.single((Iterable)((Common)result).getFields().values());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive");
                    list = IrInterpreter.interpretVararg$arrayToList(((Primitive)object).getValue());
                } else {
                    list = CollectionsKt.listOf((Object)CommonProxy.Companion.asProxy$ir_interpreter$default(CommonProxy.Companion, (Common)result, this.callInterceptor, null, 2, null));
                }
            } else {
                list = CollectionsKt.listOf((Object)result);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List args = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        if (UtilsKt.isUnsignedArray(expression.getType())) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object object;
            IrClass owner;
            block16: {
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression.getType());
                Intrinsics.checkNotNull((Object)irClassSymbol);
                owner = (IrClass)irClassSymbol.getOwner();
                Iterable $this$filterIsInstance$iv = owner.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrProperty it = (IrProperty)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"storage")) continue;
                    break block16;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty storageProperty = (IrProperty)element$iv2;
            Iterable $this$map$iv = args;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                if (it instanceof Proxy) {
                    Object object3 = CollectionsKt.single((Iterable)((Proxy)it).getState().getFields().values());
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive");
                    object2 = ((Primitive)object3).getValue();
                } else {
                    object2 = it;
                }
                collection.add(object2);
            }
            List primitiveArray = (List)destination$iv$iv3;
            IrField irField = storageProperty.getBackingField();
            Intrinsics.checkNotNull((Object)irField);
            Primitive unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, irField.getType());
            Object $this$interpretVararg_u24lambda_u243 = object = new Common(owner);
            boolean bl = false;
            $this$interpretVararg_u24lambda_u243.setField(storageProperty.getSymbol(), unsignedArray);
            state = (State)object;
        } else {
            state = UtilsKt.toPrimitiveStateArray(args, expression.getType());
        }
        State array = state;
        this.getCallStack().pushState(array);
    }

    private final void interpretTry(IrTry element) {
        block1: {
            State possibleException = this.getCallStack().peekState();
            this.getCallStack().dropSubFrame();
            if (possibleException instanceof ExceptionState) {
                Function0 checkUnhandledException = () -> IrInterpreter.interpretTry$lambda$0(this, possibleException);
                this.getCallStack().pushInstruction(new CustomInstruction((Function0<Unit>)checkUnhandledException));
            }
            IrExpression irExpression = element.getFinallyExpression();
            if (irExpression == null) break block1;
            InstructionsUnfolderKt.handleAndDropResult(irExpression, this.getCallStack());
        }
    }

    private final void interpretThrow(IrThrow expression) {
        this.getCallStack().dropFramesUntilTryCatch();
    }

    private final void interpretStringConcatenation(IrStringConcatenation expression) {
        List result = new ArrayList();
        int n = expression.getArguments().size();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            Collection collection = result;
            State state = this.getCallStack().popState();
            String string = state instanceof Primitive ? String.valueOf(((Primitive)state).getValue()) : (state instanceof Wrapper ? ((Wrapper)state).getValue().toString() : state.toString());
            collection.add(string);
        }
        this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), expression.getType()));
    }

    private final void interpretFunctionExpression(IrFunctionExpression expression) {
        IrFunction irFunction = expression.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        KFunctionState function = new KFunctionState(irFunction, (IrClass)irClassSymbol.getOwner(), this.environment, null, 8, null);
        if (AdditionalIrUtilsKt.isLocal(expression.getFunction())) {
            this.getCallStack().storeUpValues(function);
        }
        this.getCallStack().pushState(function);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretFunctionReference(IrFunctionReference reference2) {
        void $this$mapTo$iv$iv;
        IrFunction irFunction = ((IrFunctionSymbol)reference2.getSymbol()).getOwner();
        Iterable $this$map$iv = reference2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            State state;
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it != null) {
                boolean bl2 = false;
                state = this.getCallStack().popState();
            } else {
                state = null;
            }
            collection.add(state);
        }
        List boundValues = (List)destination$iv$iv;
        KFunctionState function = new KFunctionState(reference2, this.environment, (List<? extends State>)boundValues);
        if (AdditionalIrUtilsKt.isLocal(irFunction)) {
            this.getCallStack().storeUpValues(function);
        }
        this.getCallStack().pushState(function);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretPropertyReference(IrPropertyReference propertyReference) {
        List<IrTypeParameter> list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = propertyReference.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            State state;
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it != null) {
                boolean bl2 = false;
                state = this.getCallStack().popState();
            } else {
                state = null;
            }
            collection.add(state);
        }
        List boundValues = (List)destination$iv$iv;
        KPropertyState propertyState = new KPropertyState(this.callInterceptor, propertyReference, (List<? extends State>)boundValues);
        Object object = propertyReference.getGetter();
        if (object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = object.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(object, propertyReference, this, propertyState);
        }
        if ((list = propertyReference.getSetter()) != null && (list = (IrSimpleFunction)list.getOwner()) != null && (list = list.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(list, propertyReference, this, propertyState);
        }
        this.getCallStack().pushState(propertyState);
    }

    private final void interpretClassReference(IrClassReference classReference) {
        if (classReference.getSymbol() instanceof IrTypeParameterSymbol) {
            State state = this.getCallStack().loadState(classReference.getSymbol());
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kTypeState = (KTypeState)state;
            CallStack callStack = this.getCallStack();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kTypeState.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irClass = (IrClass)irClassSymbol.getOwner();
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(classReference.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol2);
            callStack.pushState(new KClassState(irClass, (IrClass)irClassSymbol2.getOwner()));
        } else {
            this.getCallStack().pushState(new KClassState(classReference));
        }
    }

    private final void interpretGetClass(IrGetClass expression) {
        IrClass irClass = this.getCallStack().popState().getIrClass();
        CallStack callStack = this.getCallStack();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        callStack.pushState(new KClassState(irClass, (IrClass)irClassSymbol.getOwner()));
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretRichFunctionReference(IrRichFunctionReference reference2) {
        void $this$mapTo$iv$iv;
        IrSimpleFunction irFunction = reference2.getInvokeFunction();
        Iterable $this$map$iv = reference2.getBoundValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List boundValues = (List)destination$iv$iv;
        KFunctionState function = new KFunctionState(reference2, this.environment, (List<? extends State>)boundValues);
        if (AdditionalIrUtilsKt.isLocal(irFunction)) {
            this.getCallStack().storeUpValues(function);
        }
        this.getCallStack().pushState(function);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretRichPropertyReference(IrRichPropertyReference reference2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = reference2.getBoundValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List boundValues = (List)destination$iv$iv;
        KPropertyState propertyState = new KPropertyState(this.callInterceptor, reference2, (List<? extends State>)boundValues);
        this.getCallStack().pushState(propertyState);
    }

    private static final Throwable interpretValueParameter$lambda$0(IrValueParameter $valueParameter, IrFunction $irFunction) {
        if ($valueParameter.getKind() == IrParameterKind.DispatchReceiver || $valueParameter.getKind() == IrParameterKind.ExtensionReceiver) {
            return new NullPointerException();
        }
        String method = UtilsKt.getCapitalizedFileName($irFunction) + '.' + UtilsKt.getFqName($irFunction);
        Name parameter = $valueParameter.getName();
        return new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
    }

    private static final State interpretCall$getThisOrSuperReceiver(State $this$interpretCall_u24getThisOrSuperReceiver, IrFunction irFunction) {
        if (!($this$interpretCall_u24getThisOrSuperReceiver instanceof Common) || ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass() == null || !(irFunction.getParent() instanceof IrClass)) {
            return $this$interpretCall_u24getThisOrSuperReceiver;
        }
        Wrapper wrapper = ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        Intrinsics.checkNotNull((Object)wrapper);
        if (IrUtilsKt.isSubclassOf(wrapper.getIrClass(), IrUtilsKt.getParentAsClass(irFunction))) {
            return ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        }
        return $this$interpretCall_u24getThisOrSuperReceiver;
    }

    private static final Unit interpretCall$lambda$5(IrInterpreter this$0, IrFunction $irFunction) {
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $irFunction);
        return Unit.INSTANCE;
    }

    private static final Unit interpretConstructorCall$lambda$5(IrInterpreter this$0, IrFunction $constructor) {
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $constructor);
        return Unit.INSTANCE;
    }

    private static final Unit interpretGetObjectValue$lambda$0(IrGetObjectValue $expression, IrInterpreter this$0) {
        boolean buildObject;
        IrClass objectClass = (IrClass)$expression.getSymbol().getOwner();
        boolean bl = buildObject = UtilsKt.hasAnnotation(objectClass, UtilsKt.getCompileTimeAnnotation()) || this$0.environment.getConfiguration().getCreateNonCompileTimeObjects();
        if (SequencesKt.none(IrUtilsKt.getConstructors(objectClass)) || !buildObject) {
            Common state = new Common(objectClass);
            this$0.environment.getMapOfObjects$ir_interpreter().put(objectClass.getSymbol(), state);
            this$0.getCallStack().pushState(state);
            return Unit.INSTANCE;
        }
        IrConstructor constructor = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors(objectClass));
        IrConstructorCallImpl constructorCall = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor.getReturnType(), constructor.getSymbol(), null, 4, null);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), constructorCall);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit interpretEnumEntry$lambda$0(IrEnumEntry $enumEntry, IrInterpreter this$0) {
        Common enumClassObject = UtilsKt.toState($enumEntry, this$0.getIrBuiltIns());
        this$0.environment.getMapOfEnums$ir_interpreter().put($enumEntry.getSymbol(), enumClassObject);
        IrElementBase irElementBase = $enumEntry.getInitializerExpression();
        if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
            throw new InterpreterError("Initializer at enum entry " + UtilsKt.getFqName($enumEntry) + " is null");
        }
        IrElementBase enumInitializer = irElementBase;
        IrEnumConstructorCall irEnumConstructorCall = enumInitializer instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)enumInitializer : null;
        if (irEnumConstructorCall == null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((IrBlock)enumInitializer).getStatements();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrEnumConstructorCall)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irEnumConstructorCall = (IrEnumConstructorCall)CollectionsKt.single((List)((List)destination$iv$iv));
        }
        IrEnumConstructorCall enumConstructorCall = irEnumConstructorCall;
        this$0.getCallStack().newSubFrame($enumEntry);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $enumEntry);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), enumInitializer);
        this$0.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(enumConstructorCall), enumClassObject);
        return Unit.INSTANCE;
    }

    private static final Object interpretTypeOperatorCall$lambda$3(IrTypeOperatorCall $expression) {
        return "Type operator " + (Object)((Object)$expression.getOperator()) + " is not supported for interpretation";
    }

    private static final List<Object> interpretVararg$arrayToList(Object value) {
        Object object = value;
        return CollectionsKt.reversed((Iterable)(object instanceof byte[] ? ArraysKt.toList((byte[])((byte[])value)) : (object instanceof char[] ? ArraysKt.toList((char[])((char[])value)) : (object instanceof short[] ? ArraysKt.toList((short[])((short[])value)) : (object instanceof int[] ? ArraysKt.toList((int[])((int[])value)) : (object instanceof long[] ? ArraysKt.toList((long[])((long[])value)) : (object instanceof float[] ? ArraysKt.toList((float[])((float[])value)) : (object instanceof double[] ? ArraysKt.toList((double[])((double[])value)) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])((boolean[])value)) : (object instanceof Object[] ? ArraysKt.toList((Object[])((Object[])value)) : CollectionsKt.listOf((Object)value)))))))))));
    }

    private static final Unit interpretTry$lambda$0(IrInterpreter this$0, State possibleException) {
        this$0.getCallStack().pushState(possibleException);
        this$0.getCallStack().dropFramesUntilTryCatch();
        return Unit.INSTANCE;
    }

    private static final void interpretPropertyReference$addToFields(List<? extends IrTypeParameter> $this$interpretPropertyReference_u24addToFields, IrPropertyReference $propertyReference, IrInterpreter this$0, KPropertyState propertyState) {
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)$propertyReference.getTypeArguments());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            IrType typeArgument;
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if ($propertyReference.getTypeArguments().get(index) == null) continue;
            KTypeState kTypeState = new KTypeState(typeArgument, (IrClass)this$0.environment.getKTypeClass$ir_interpreter().getOwner());
            propertyState.setField($this$interpretPropertyReference_u24addToFields.get(index).getSymbol(), kTypeState);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

