/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.WindowsPipe;
import com.jetbrains.cef.remote.WindowsPipeSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public class WindowsPipeServerSocket
extends ServerSocket {
    static final int PIPE_UNLIMITED_INSTANCES = 255;
    private static final int BUFFER_SIZE = 65535;
    private final LinkedBlockingQueue<Long> myOpenHandles = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Long> myConnectedHandles = new LinkedBlockingQueue();
    private final String myPath;
    private final int myMaxInstances;
    private Consumer<Long> myCloseCallback = handle -> {
        if (this.myConnectedHandles.remove(handle)) {
            this.closeConnectedPipe((long)handle);
        }
        if (this.myOpenHandles.remove(handle)) {
            WindowsPipe.CloseHandle(handle);
        }
    };

    public WindowsPipeServerSocket(String path) throws IOException {
        this.myMaxInstances = 255;
        this.myPath = WindowsPipe.normalizePipePath(path);
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        throw new IOException("Windows named pipes do not support bind(), pass path to constructor");
    }

    @Override
    public Socket accept() throws IOException {
        long handle;
        try {
            handle = WindowsPipe.CreateNamedPipe(this.myPath, WindowsPipe.PIPE_ACCESS_DUPLEX | WindowsPipe.FILE_FLAG_OVERLAPPED, 0, this.myMaxInstances, 65535, 65535, 0, WindowsPipe.FILE_ALL_ACCESS);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not create named pipe, error %d", WindowsPipe.GetLastError()));
        }
        this.myOpenHandles.add(handle);
        long connWaitable = WindowsPipe.CreateEvent(true, false, null);
        long overlapped = WindowsPipe.NewOverlapped(connWaitable);
        try {
            int connectError = WindowsPipe.ConnectNamedPipe(handle, overlapped);
            if (connectError == -1) {
                this.myOpenHandles.remove(handle);
                this.myConnectedHandles.add(handle);
                WindowsPipeSocket windowsPipeSocket = new WindowsPipeSocket(handle, this.myCloseCallback);
                return windowsPipeSocket;
            }
            if (connectError == WindowsPipe.ERROR_PIPE_CONNECTED) {
                this.myOpenHandles.remove(handle);
                this.myConnectedHandles.add(handle);
                WindowsPipeSocket windowsPipeSocket = new WindowsPipeSocket(handle, this.myCloseCallback);
                return windowsPipeSocket;
            }
            if (connectError == WindowsPipe.ERROR_NO_DATA) {
                WindowsPipeSocket windowsPipeSocket = new WindowsPipeSocket(handle, this.myCloseCallback);
                return windowsPipeSocket;
            }
            if (connectError == WindowsPipe.ERROR_IO_PENDING) {
                if (!WindowsPipe.GetOverlappedResult(handle, overlapped)) {
                    this.myOpenHandles.remove(handle);
                    WindowsPipe.CloseHandle(handle);
                    throw new IOException("GetOverlappedResult() failed for connect operation, err=" + WindowsPipe.GetLastError());
                }
                this.myOpenHandles.remove(handle);
                this.myConnectedHandles.add(handle);
                WindowsPipeSocket windowsPipeSocket = new WindowsPipeSocket(handle, this.myCloseCallback);
                return windowsPipeSocket;
            }
            throw new IOException("ConnectNamedPipe() failed with: " + connectError);
        }
        finally {
            WindowsPipe.DeleteOverlapped(overlapped);
            WindowsPipe.CloseHandle(connWaitable);
        }
    }

    @Override
    public void close() throws IOException {
        ArrayList handlesToClose = new ArrayList();
        this.myOpenHandles.drainTo(handlesToClose);
        Iterator iterator = handlesToClose.iterator();
        while (iterator.hasNext()) {
            long handle = (Long)iterator.next();
            WindowsPipe.CloseHandle(handle);
        }
        ArrayList handlesToDisconnect = new ArrayList();
        this.myConnectedHandles.drainTo(handlesToDisconnect);
        Iterator iterator2 = handlesToDisconnect.iterator();
        while (iterator2.hasNext()) {
            long handle = (Long)iterator2.next();
            this.closeConnectedPipe(handle);
        }
    }

    private void closeConnectedPipe(long handle) {
        WindowsPipe.FlushFileBuffers(handle);
        WindowsPipe.DisconnectNamedPipe(handle);
        WindowsPipe.CloseHandle(handle);
    }
}

