/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.RevisionRange;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public class BranchMerger
implements IMerger {
    private static final Logger LOG = Logger.getInstance(BranchMerger.class);
    private final SvnVcs myVcs;
    private final String myTargetPath;
    private final Url mySourceUrl;
    private final UpdateEventHandler myHandler;
    private final boolean myReintegrate;
    private final String myBranchName;
    private final long mySourceCopyRevision;
    private boolean myAtStart;
    private Revision mySourceLatestRevision;
    private final boolean mySupportsMergeInfo;

    public BranchMerger(SvnVcs vcs, Url sourceUrl, String targetPath, UpdateEventHandler handler, boolean isReintegrate, String branchName, long sourceCopyRevision, boolean supportsMergeInfo) {
        this.myVcs = vcs;
        this.myTargetPath = targetPath;
        this.mySourceUrl = sourceUrl;
        this.myHandler = handler;
        this.myReintegrate = isReintegrate;
        this.myBranchName = branchName;
        this.mySourceCopyRevision = sourceCopyRevision;
        this.myAtStart = true;
        this.mySupportsMergeInfo = supportsMergeInfo;
    }

    @Override
    @NotNull
    public String getComment() {
        String string = this.mySupportsMergeInfo ? (this.myReintegrate ? SvnBundle.message("label.merge.all.from.branch.reintegrate", this.myBranchName) : SvnBundle.message("label.merge.all.from.branch", this.myBranchName)) : (this.myReintegrate ? SvnBundle.message("label.merge.all.from.branch.at.revision.reintegrate", this.myBranchName, this.mySourceLatestRevision) : SvnBundle.message("label.merge.all.from.branch.at.revision", this.myBranchName, this.mySourceLatestRevision));
        if (string == null) {
            BranchMerger.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean hasNext() {
        return this.myAtStart;
    }

    @Override
    public void mergeNext() throws VcsException {
        this.myAtStart = false;
        File destination = new File(this.myTargetPath);
        MergeClient client = this.myVcs.getFactory(destination).createMergeClient();
        Target source = Target.on(this.mySourceUrl);
        if (this.mySupportsMergeInfo) {
            client.merge(source, destination, false, this.myReintegrate, this.createDiffOptions(), this.myHandler);
        } else {
            this.mySourceLatestRevision = this.resolveSourceLatestRevision();
            RevisionRange range = new RevisionRange(Revision.of(this.mySourceCopyRevision), this.mySourceLatestRevision);
            client.merge(source, range, destination, Depth.UNKNOWN, false, false, true, this.createDiffOptions(), this.myHandler);
        }
    }

    @NotNull
    private DiffOptions createDiffOptions() {
        DiffOptions diffOptions = this.myVcs.getSvnConfiguration().getMergeOptions();
        if (diffOptions == null) {
            BranchMerger.$$$reportNull$$$0(1);
        }
        return diffOptions;
    }

    @Override
    @Nullable
    public String getInfo() {
        return null;
    }

    @Override
    public File getMergeInfoHolder() {
        return new File(this.myTargetPath);
    }

    @Override
    public void afterProcessing() {
    }

    @Override
    @Nullable
    public String getSkipped() {
        return null;
    }

    @NotNull
    public Revision resolveSourceLatestRevision() {
        Revision result = Revision.HEAD;
        try {
            result = SvnUtil.getHeadRevision(this.myVcs, this.mySourceUrl);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        Revision revision = result;
        if (revision == null) {
            BranchMerger.$$$reportNull$$$0(2);
        }
        return revision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/svn/integrate/BranchMerger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSourceLatestRevision";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

