/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAddImportAction
extends ImportClassFixBase<GrReferenceElement<?>, GrReferenceElement<?>> {
    private final GrReferenceElement<?> ref;

    public GroovyAddImportAction(@NotNull GrReferenceElement<?> ref2) {
        if (ref2 == null) {
            GroovyAddImportAction.$$$reportNull$$$0(0);
        }
        super(ref2, ref2);
        this.ref = ref2;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiFile containingFile;
        if (project == null) {
            GroovyAddImportAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GroovyAddImportAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            GroovyAddImportAction.$$$reportNull$$$0(3);
        }
        if (!((containingFile = this.ref.getContainingFile()) instanceof GroovyFile)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                GroovyAddImportAction.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }
        String fileName = containingFile.getName();
        GrImportStatement[] imports2 = ((GroovyFile)containingFile).getImportStatements();
        StringBuilder builder = new StringBuilder();
        for (GrImportStatement importStmt : imports2) {
            builder.append(importStmt.getText());
            builder.append("\n");
        }
        String before = builder.toString();
        builder.append("import package1.package2.").append(this.ref.getReferenceName());
        String after = builder.toString();
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, fileName, before, after);
    }

    protected String getReferenceName(@NotNull GrReferenceElement<?> reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(5);
        }
        return reference.getReferenceName();
    }

    protected PsiElement getReferenceNameElement(@NotNull GrReferenceElement<?> reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(6);
        }
        return reference.getReferenceNameElement();
    }

    protected boolean hasTypeParameters(@NotNull GrReferenceElement<?> reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(7);
        }
        return reference.getTypeArguments().length > 0;
    }

    protected String getQualifiedName(@NotNull GrReferenceElement<?> referenceElement) {
        if (referenceElement == null) {
            GroovyAddImportAction.$$$reportNull$$$0(8);
        }
        return referenceElement.getCanonicalText();
    }

    protected boolean isQualified(@NotNull GrReferenceElement<?> reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(9);
        }
        return reference.getQualifier() != null;
    }

    protected boolean hasUnresolvedImportWhichCanImport(@NotNull PsiFile psiFile, @NotNull String name) {
        GrImportStatement[] importStatements;
        if (psiFile == null) {
            GroovyAddImportAction.$$$reportNull$$$0(10);
        }
        if (name == null) {
            GroovyAddImportAction.$$$reportNull$$$0(11);
        }
        if (!(psiFile instanceof GroovyFile)) {
            return false;
        }
        for (GrImportStatement importStatement : importStatements = ((GroovyFile)psiFile).getImportStatements()) {
            GrCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null || importReference.resolve() != null || !importStatement.isOnDemand() && !Comparing.strEqual((String)importStatement.getImportedName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Collection<PsiClass> filterByContext(@NotNull Collection<PsiClass> candidates, @NotNull GrReferenceElement<?> referenceElement) {
        PsiElement typeElement;
        if (candidates == null) {
            GroovyAddImportAction.$$$reportNull$$$0(12);
        }
        if (referenceElement == null) {
            GroovyAddImportAction.$$$reportNull$$$0(13);
        }
        if ((typeElement = referenceElement.getParent()) instanceof GrTypeElement) {
            PsiType type;
            PsiExpression initializer;
            GrVariable[] vars;
            PsiElement decl = typeElement.getParent();
            if (decl instanceof GrVariableDeclaration && (vars = ((GrVariableDeclaration)decl).getVariables()).length == 1 && (initializer = vars[0].getInitializer()) != null && (type = initializer.getType()) != null) {
                Collection collection = GroovyAddImportAction.filterAssignableFrom((PsiType)type, candidates);
                if (collection == null) {
                    GroovyAddImportAction.$$$reportNull$$$0(14);
                }
                return collection;
            }
            if (decl instanceof GrParameter) {
                Collection collection = GroovyAddImportAction.filterBySuperMethods((PsiParameter)((PsiParameter)decl), candidates);
                if (collection == null) {
                    GroovyAddImportAction.$$$reportNull$$$0(15);
                }
                return collection;
            }
        }
        Collection collection = super.filterByContext(candidates, referenceElement);
        if (collection == null) {
            GroovyAddImportAction.$$$reportNull$$$0(16);
        }
        return collection;
    }

    protected String getRequiredMemberName(@NotNull GrReferenceElement<?> referenceElement) {
        if (referenceElement == null) {
            GroovyAddImportAction.$$$reportNull$$$0(17);
        }
        if (referenceElement.getParent() instanceof GrReferenceElement) {
            return ((GrReferenceElement)referenceElement.getParent()).getReferenceName();
        }
        return super.getRequiredMemberName(referenceElement);
    }

    protected boolean isAccessible(@NotNull PsiMember member, @NotNull GrReferenceElement<?> referenceElement) {
        if (member == null) {
            GroovyAddImportAction.$$$reportNull$$$0(18);
        }
        if (referenceElement == null) {
            GroovyAddImportAction.$$$reportNull$$$0(19);
        }
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            GroovyAddImportAction.$$$reportNull$$$0(20);
        }
        if (!this.ref.isValid()) {
            return false;
        }
        PsiFile containingFile = this.ref.getContainingFile();
        if (containingFile instanceof GroovyFile) {
            List alreadyImportedClasses = ContainerUtil.map((Object[])((GroovyFile)containingFile).getImportStatements(), GrImportStatement::resolveTargetClass);
            for (PsiClass classToImport : this.getClassesToImport()) {
                if (!alreadyImportedClasses.contains(classToImport)) continue;
                return false;
            }
        }
        return super.showHint(editor);
    }

    protected void bindReference(@NotNull PsiReference reference, @NotNull PsiClass targetClass) {
        PsiElement referringElement;
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(21);
        }
        if (targetClass == null) {
            GroovyAddImportAction.$$$reportNull$$$0(22);
        }
        if ((referringElement = reference.getElement()).getParent() instanceof GrMethodCall && referringElement instanceof GrReferenceExpression && PsiUtil.isNewified(referringElement)) {
            GroovyAddImportAction.handleNewifiedClass(referringElement, targetClass);
        } else {
            super.bindReference(reference, targetClass);
        }
    }

    private static void handleNewifiedClass(@NotNull PsiElement referringElement, @NotNull PsiClass targetClass) {
        PsiFile file;
        if (referringElement == null) {
            GroovyAddImportAction.$$$reportNull$$$0(23);
        }
        if (targetClass == null) {
            GroovyAddImportAction.$$$reportNull$$$0(24);
        }
        if ((file = referringElement.getContainingFile()) instanceof GroovyFile) {
            ((GroovyFile)file).importClass(targetClass);
            JavaModuleGraphUtil.addDependency((PsiElement)file, (PsiClass)targetClass, null);
        }
    }

    protected boolean isClassDefinitelyPositivelyImportedAlready(@NotNull PsiFile containingFile, @NotNull PsiClass classToImport) {
        GrImportStatement[] importList;
        if (containingFile == null) {
            GroovyAddImportAction.$$$reportNull$$$0(25);
        }
        if (classToImport == null) {
            GroovyAddImportAction.$$$reportNull$$$0(26);
        }
        if ((importList = ((GroovyFile)containingFile).getImportStatements()) == null) {
            return false;
        }
        String classQualifiedName = classToImport.getQualifiedName();
        String packageName = classQualifiedName == null ? "" : StringUtil.getPackageName((String)classQualifiedName);
        boolean result2 = false;
        for (GrImportStatement statement : importList) {
            GrCodeReferenceElement importRef = statement.getImportReference();
            if (importRef == null) continue;
            String canonicalText = importRef.getCanonicalText();
            if (statement.isOnDemand()) {
                if (!canonicalText.equals(packageName)) continue;
                result2 = true;
                break;
            }
            if (!canonicalText.equals(classQualifiedName)) continue;
            result2 = true;
            break;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GroovyAddImportAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referringElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GroovyAddImportAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceNameElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isQualified";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedImportWhichCanImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterByContext";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredMemberName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "bindReference";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleNewifiedClass";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isClassDefinitelyPositivelyImportedAlready";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

